/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.crypt.x509.types;

import edu.vt.middleware.crypt.x509.types.PolicyQualifierInfo;
import java.util.Arrays;

public class PolicyInformation {
    private static final int HASH_FACTOR = 31;
    private String policyIdentifier;
    private PolicyQualifierInfo[] policyQualifiers;

    public PolicyInformation(String oid) {
        this(oid, null);
    }

    public PolicyInformation(String oid, PolicyQualifierInfo[] qualifiers) {
        if (oid == null || "".equals(oid)) {
            throw new IllegalArgumentException("Policy information OID cannot be null or empty string.");
        }
        this.policyIdentifier = oid;
        this.policyQualifiers = qualifiers;
    }

    public String getPolicyIdentifier() {
        return this.policyIdentifier;
    }

    public PolicyQualifierInfo[] getPolicyQualifiers() {
        return this.policyQualifiers;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.policyIdentifier);
        if (this.policyQualifiers != null) {
            sb.append(":[");
            for (PolicyQualifierInfo info : this.policyQualifiers) {
                sb.append(info);
            }
            sb.append(']');
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        PolicyInformation other;
        boolean result = false;
        result = obj == this ? true : (obj == null || obj.getClass() != this.getClass() ? false : this.policyIdentifier.equals((other = (PolicyInformation)obj).getPolicyIdentifier()) && (this.policyQualifiers != null ? Arrays.equals(this.policyQualifiers, other.getPolicyQualifiers()) : other.getPolicyQualifiers() == null));
        return result;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = 31 * hash + this.policyIdentifier.hashCode();
        if (this.policyQualifiers != null) {
            hash = 31 * hash + Arrays.hashCode(this.policyQualifiers);
        }
        return hash;
    }
}

