/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.subtle;

import com.google.crypto.tink.subtle.Snuffle;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.InvalidKeyException;

class ChaCha20
extends Snuffle {
    private static final byte[] ZERO_16_BYTES = new byte[16];

    ChaCha20(byte[] key, int initialCounter) throws InvalidKeyException {
        super(key, initialCounter);
    }

    private int[] createInitialState(byte[] nonce, int counter) {
        int[] state = new int[16];
        ChaCha20.setSigma(state);
        ChaCha20.setKey(state, this.key.getBytes());
        state[12] = counter;
        System.arraycopy(ChaCha20.toIntArray(ByteBuffer.wrap(nonce)), 0, state, 13, this.nonceSizeInBytes() / 4);
        return state;
    }

    @Override
    int nonceSizeInBytes() {
        return 12;
    }

    @Override
    ByteBuffer getKeyStreamBlock(byte[] nonce, int counter) {
        int[] state = this.createInitialState(nonce, counter);
        int[] workingState = (int[])state.clone();
        ChaCha20.shuffleState(workingState);
        for (int i = 0; i < state.length; ++i) {
            int n = i;
            state[n] = state[n] + workingState[i];
        }
        ByteBuffer out = ByteBuffer.allocate(64).order(ByteOrder.LITTLE_ENDIAN);
        out.asIntBuffer().put(state, 0, 16);
        return out;
    }

    private static void setSigma(int[] state) {
        System.arraycopy(Snuffle.SIGMA, 0, state, 0, SIGMA.length);
    }

    private static void setKey(int[] state, byte[] key) {
        int[] keyInt = ChaCha20.toIntArray(ByteBuffer.wrap(key));
        System.arraycopy(keyInt, 0, state, 4, keyInt.length);
    }

    private static void shuffleState(int[] state) {
        for (int i = 0; i < 10; ++i) {
            ChaCha20.quarterRound(state, 0, 4, 8, 12);
            ChaCha20.quarterRound(state, 1, 5, 9, 13);
            ChaCha20.quarterRound(state, 2, 6, 10, 14);
            ChaCha20.quarterRound(state, 3, 7, 11, 15);
            ChaCha20.quarterRound(state, 0, 5, 10, 15);
            ChaCha20.quarterRound(state, 1, 6, 11, 12);
            ChaCha20.quarterRound(state, 2, 7, 8, 13);
            ChaCha20.quarterRound(state, 3, 4, 9, 14);
        }
    }

    static void quarterRound(int[] x, int a, int b, int c, int d) {
        int n = a;
        x[n] = x[n] + x[b];
        x[d] = ChaCha20.rotateLeft(x[d] ^ x[a], 16);
        int n2 = c;
        x[n2] = x[n2] + x[d];
        x[b] = ChaCha20.rotateLeft(x[b] ^ x[c], 12);
        int n3 = a;
        x[n3] = x[n3] + x[b];
        x[d] = ChaCha20.rotateLeft(x[d] ^ x[a], 8);
        int n4 = c;
        x[n4] = x[n4] + x[d];
        x[b] = ChaCha20.rotateLeft(x[b] ^ x[c], 7);
    }
}

