/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.subtle;

import java.util.Arrays;

class AesUtil {
    public static final int BLOCK_SIZE = 16;

    AesUtil() {
    }

    static byte[] dbl(byte[] value) {
        byte[] res = new byte[value.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = (byte)(0xFE & value[i] << 1);
            if (i >= res.length - 1) continue;
            int n = i;
            res[n] = (byte)(res[n] | (byte)(1 & value[i + 1] >> 7));
        }
        res[15] = (byte)(res[15] ^ (byte)(0x87 & value[0] >> 7));
        return res;
    }

    static byte[] cmacPad(byte[] x) {
        if (x.length >= 16) {
            throw new IllegalArgumentException("x must be smaller than a block.");
        }
        byte[] result = Arrays.copyOf(x, 16);
        result[x.length] = -128;
        return result;
    }
}

