/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.integration.gcpkms;

import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.cloudkms.v1.CloudKMS;
import com.google.api.services.cloudkms.v1.CloudKMSScopes;
import com.google.crypto.tink.Aead;
import com.google.crypto.tink.KmsClient;
import com.google.crypto.tink.integration.gcpkms.GcpKmsAead;
import com.google.crypto.tink.subtle.Validators;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.util.Collection;

public final class GcpKmsClient
implements KmsClient {
    public static final String PREFIX = "gcp-kms://";
    private static final String APPLICATION_NAME = "Tink";
    private CloudKMS client;
    private String keyUri;

    public GcpKmsClient() {
    }

    public GcpKmsClient(String uri) {
        if (!uri.toLowerCase().startsWith(PREFIX)) {
            throw new IllegalArgumentException("key URI must starts with gcp-kms://");
        }
        this.keyUri = uri;
    }

    @Override
    public boolean doesSupport(String uri) {
        if (this.keyUri != null && this.keyUri.equals(uri)) {
            return true;
        }
        return this.keyUri == null && uri.toLowerCase().startsWith(PREFIX);
    }

    @Override
    public KmsClient withCredentials(String credentialPath) throws GeneralSecurityException {
        if (credentialPath == null) {
            return this.withDefaultCredentials();
        }
        try {
            GoogleCredential credentials = GoogleCredential.fromStream((InputStream)new FileInputStream(new File(credentialPath)));
            return this.withCredentials(credentials);
        }
        catch (IOException e) {
            throw new GeneralSecurityException("cannot load credentials", e);
        }
    }

    @Override
    public KmsClient withDefaultCredentials() throws GeneralSecurityException {
        try {
            GoogleCredential credentials = GoogleCredential.getApplicationDefault((HttpTransport)new NetHttpTransport(), (JsonFactory)new JacksonFactory());
            return this.withCredentials(credentials);
        }
        catch (IOException e) {
            throw new GeneralSecurityException("cannot load default credentials", e);
        }
    }

    private KmsClient withCredentials(GoogleCredential credential) {
        if (credential.createScopedRequired()) {
            credential = credential.createScoped((Collection)CloudKMSScopes.all());
        }
        this.client = new CloudKMS.Builder((HttpTransport)new NetHttpTransport(), (JsonFactory)new JacksonFactory(), (HttpRequestInitializer)credential).setApplicationName(APPLICATION_NAME).build();
        return this;
    }

    @Override
    public Aead getAead(String uri) throws GeneralSecurityException {
        if (this.keyUri != null && !this.keyUri.equals(uri)) {
            throw new GeneralSecurityException(String.format("this client is bound to %s, cannot load keys bound to %s", this.keyUri, uri));
        }
        return new GcpKmsAead(this.client, Validators.validateKmsKeyUriAndRemovePrefix(PREFIX, uri));
    }
}

