/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.daead;

import com.google.crypto.tink.DeterministicAead;
import com.google.crypto.tink.KeyManager;
import com.google.crypto.tink.KeysetHandle;
import com.google.crypto.tink.PrimitiveSet;
import com.google.crypto.tink.Registry;
import com.google.crypto.tink.subtle.Bytes;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;

public final class DeterministicAeadFactory {
    private static final Logger logger = Logger.getLogger(DeterministicAeadFactory.class.getName());

    public static DeterministicAead getPrimitive(KeysetHandle keysetHandle) throws GeneralSecurityException {
        return DeterministicAeadFactory.getPrimitive(keysetHandle, null);
    }

    public static DeterministicAead getPrimitive(KeysetHandle keysetHandle, KeyManager<DeterministicAead> keyManager) throws GeneralSecurityException {
        final PrimitiveSet<DeterministicAead> primitives = Registry.getPrimitives(keysetHandle, keyManager);
        DeterministicAeadFactory.validate(primitives);
        return new DeterministicAead(){

            @Override
            public byte[] encryptDeterministically(byte[] plaintext, byte[] associatedData) throws GeneralSecurityException {
                return Bytes.concat(primitives.getPrimary().getIdentifier(), ((DeterministicAead)primitives.getPrimary().getPrimitive()).encryptDeterministically(plaintext, associatedData));
            }

            @Override
            public byte[] decryptDeterministically(byte[] ciphertext, byte[] associatedData) throws GeneralSecurityException {
                if (ciphertext.length > 5) {
                    byte[] prefix = Arrays.copyOfRange(ciphertext, 0, 5);
                    byte[] ciphertextNoPrefix = Arrays.copyOfRange(ciphertext, 5, ciphertext.length);
                    List entries = primitives.getPrimitive(prefix);
                    for (PrimitiveSet.Entry entry : entries) {
                        try {
                            return ((DeterministicAead)entry.getPrimitive()).decryptDeterministically(ciphertextNoPrefix, associatedData);
                        }
                        catch (GeneralSecurityException e) {
                            logger.info("ciphertext prefix matches a key, but cannot decrypt: " + e.toString());
                        }
                    }
                }
                List entries = primitives.getRawPrimitives();
                for (PrimitiveSet.Entry entry : entries) {
                    try {
                        return ((DeterministicAead)entry.getPrimitive()).decryptDeterministically(ciphertext, associatedData);
                    }
                    catch (GeneralSecurityException e) {
                    }
                }
                throw new GeneralSecurityException("decryption failed");
            }
        };
    }

    private static void validate(PrimitiveSet<DeterministicAead> pset) throws GeneralSecurityException {
        for (Collection collection : pset.getAll()) {
            for (PrimitiveSet.Entry entry : collection) {
                if (entry.getPrimitive() instanceof DeterministicAead) continue;
                throw new GeneralSecurityException("invalid Deterministic AEAD key material");
            }
        }
    }
}

