/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.util;

import gnu.crypto.hash.IMessageDigest;
import java.io.ByteArrayOutputStream;
import java.util.Random;
import net.jradius.util.MD5;

public final class RadiusUtils {
    public static byte[] encodePapPassword(byte[] userPass, byte[] requestAuthenticator, String sharedSecret) {
        int i;
        IMessageDigest md5 = MD5.getMD5();
        byte[] userPassBytes = null;
        if (userPass.length > 128) {
            userPassBytes = new byte[128];
            System.arraycopy(userPass, 0, userPassBytes, 0, 128);
        } else {
            userPassBytes = userPass;
        }
        byte[] encryptedPass = null;
        encryptedPass = userPassBytes.length < 128 ? (userPassBytes.length % 16 == 0 ? new byte[userPassBytes.length] : new byte[userPassBytes.length / 16 * 16 + 16]) : new byte[128];
        System.arraycopy(userPassBytes, 0, encryptedPass, 0, userPassBytes.length);
        for (int i2 = userPassBytes.length; i2 < encryptedPass.length; ++i2) {
            encryptedPass[i2] = 0;
        }
        md5.update(sharedSecret.getBytes(), 0, sharedSecret.length());
        md5.update(requestAuthenticator, 0, requestAuthenticator.length);
        byte[] bn = md5.digest();
        for (i = 0; i < 16; ++i) {
            encryptedPass[i] = (byte)(bn[i] ^ encryptedPass[i]);
        }
        if (encryptedPass.length > 16) {
            for (i = 16; i < encryptedPass.length; i += 16) {
                md5.reset();
                md5.update(sharedSecret.getBytes(), 0, sharedSecret.length());
                md5.update(encryptedPass, i - 16, 16);
                bn = md5.digest();
                for (int j = 0; j < 16; ++j) {
                    encryptedPass[i + j] = (byte)(bn[j] ^ encryptedPass[i + j]);
                }
            }
        }
        return encryptedPass;
    }

    public static byte[] decodePapPassword(byte[] encryptedPass, byte[] authenticator, String sharedSecret) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IMessageDigest md5 = MD5.getMD5();
        int pwlen = encryptedPass.length;
        if (pwlen > 128) {
            pwlen = 128;
        }
        if (pwlen == 0) {
            return out.toByteArray();
        }
        md5.update(sharedSecret.getBytes(), 0, sharedSecret.length());
        md5.update(authenticator, 0, authenticator.length);
        byte[] hash = md5.digest();
        for (int n = 0; n < pwlen; n += 16) {
            if (n == 0) {
                md5.update(sharedSecret.getBytes(), 0, sharedSecret.length());
                if (pwlen > 16) {
                    md5.update(encryptedPass, 0, 16);
                }
            } else {
                hash = md5.digest();
                md5.update(sharedSecret.getBytes(), 0, sharedSecret.length());
                if (pwlen > n + 16) {
                    md5.update(encryptedPass, n, 16);
                }
            }
            for (int i = 0; i < 16; ++i) {
                out.write(encryptedPass[i + n] ^ hash[i]);
            }
        }
        return out.toByteArray();
    }

    public static byte[] makeRFC2865RequestAuthenticator(String sharedSecret) {
        IMessageDigest md5 = MD5.getMD5();
        byte[] requestAuthenticator = new byte[16];
        Random r = new Random();
        for (int i = 0; i < 16; ++i) {
            requestAuthenticator[i] = (byte)r.nextInt();
        }
        md5.update(sharedSecret.getBytes(), 0, sharedSecret.length());
        md5.update(requestAuthenticator, 0, requestAuthenticator.length);
        return md5.digest();
    }

    public static byte[] makeRFC2865ResponseAuthenticator(String sharedSecret, byte code, byte identifier, short length, byte[] requestAuthenticator, byte[] responseAttributeBytes, int responseAttributeLength) {
        IMessageDigest md5 = MD5.getMD5();
        md5.update(code);
        md5.update(identifier);
        md5.update((byte)(length >> 8));
        md5.update((byte)(length & 0xFF));
        md5.update(requestAuthenticator, 0, requestAuthenticator.length);
        md5.update(responseAttributeBytes, 0, responseAttributeLength);
        md5.update(sharedSecret.getBytes(), 0, sharedSecret.length());
        return md5.digest();
    }

    public static byte[] makeRFC2866RequestAuthenticator(String sharedSecret, byte code, byte identifier, int length, byte[] requestAttributes, int attributesOffset, int attributesLength) {
        IMessageDigest md5 = MD5.getMD5();
        byte[] requestAuthenticator = new byte[16];
        md5.reset();
        md5.update(code);
        md5.update(identifier);
        md5.update((byte)(length >> 8));
        md5.update((byte)(length & 0xFF));
        md5.update(requestAuthenticator, 0, requestAuthenticator.length);
        md5.update(requestAttributes, attributesOffset, attributesLength);
        md5.update(sharedSecret.getBytes(), 0, sharedSecret.length());
        return md5.digest();
    }

    public static String byteArrayToHexString(byte[] in) {
        byte ch = 0;
        if (in == null || in.length <= 0) {
            return null;
        }
        String[] pseudo = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
        StringBuffer out = new StringBuffer(in.length * 2);
        for (int i = 0; i < in.length; ++i) {
            ch = (byte)(in[i] & 0xF0);
            ch = (byte)(ch >>> 4);
            ch = (byte)(ch & 0xF);
            out.append(pseudo[ch]);
            ch = (byte)(in[i] & 0xF);
            out.append(pseudo[ch]);
        }
        String rslt = new String(out);
        return rslt;
    }
}

