/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.xmlsig.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;

public class KeyExport {
    public static final File DEFAULT_KEYSTORE = new File(System.getProperty("user.home"), ".keystore");

    public static void main(String[] argv) {
        File exportFile = null;
        String keyStoreAlias = null;
        File keyStoreFile = null;
        char[] storePassword = null;
        char[] keyPassword = null;
        if (argv.length % 2 != 0) {
            KeyExport.usage();
        }
        for (int i = 0; i < argv.length; i += 2) {
            String name = argv[i];
            String val = argv[i + 1];
            if (name.equals("-file")) {
                exportFile = new File(val);
                continue;
            }
            if (name.equals("-alias")) {
                keyStoreAlias = val;
                continue;
            }
            if (name.equals("-keystore")) {
                keyStoreFile = new File(val);
                continue;
            }
            if (name.equals("-storepass")) {
                storePassword = val.toCharArray();
                continue;
            }
            if (!name.equals("-keypass")) continue;
            keyPassword = val.toCharArray();
        }
        if (exportFile == null) {
            KeyExport.usage();
        }
        if (storePassword == null || keyPassword == null) {
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            try {
                String line;
                if (storePassword == null) {
                    System.out.print("store-password: ");
                    line = in.readLine();
                    if (line == null || line.length() == 0) {
                        KeyExport.usage();
                    }
                    storePassword = line.toCharArray();
                }
                if (keyPassword == null) {
                    System.out.println("(press return to use store-password)");
                    System.out.print("key-password: ");
                    line = in.readLine();
                    if (line == null || line.length() == 0) {
                        KeyExport.usage();
                    }
                    keyPassword = line.length() == 0 ? storePassword : line.toCharArray();
                }
            }
            catch (IOException e) {
                KeyExport.usage();
            }
        }
        if (keyStoreFile == null) {
            keyStoreFile = DEFAULT_KEYSTORE;
        }
        try {
            KeyExport.keyExport(exportFile, keyStoreAlias, keyStoreFile, storePassword, keyPassword);
            System.out.println("Exported PKCS8 file " + exportFile + " from keystore " + keyStoreFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println();
        }
    }

    public static void usage() {
        System.err.println("usage:\n java KeyExport\n     -file keyfile               # pkcs8 file to be written\n     -alias alias                # alias of key to export\n   [ -keystore keystore-file ]   # defaults to {user-home}/.keystore\n   [ -storepass store-password ] # user is prompted if omitted\n   [ -keypass key-password ]     # user is prompted if omitted and may\n                                 # hit return to use store-password\n\n");
        System.exit(2);
    }

    public static void keyExport(File exportFile, String keyStoreAlias, File keyStoreFile, char[] storePassword, char[] keyPassword) throws IllegalArgumentException, IOException, GeneralSecurityException {
        if (keyStoreFile == null) {
            keyStoreFile = DEFAULT_KEYSTORE;
        }
        String keyStoreType = KeyStore.getDefaultType();
        KeyStore keyStore = KeyStore.getInstance(keyStoreType);
        FileInputStream is = new FileInputStream(keyStoreFile);
        keyStore.load(is, storePassword);
        is.close();
        if (!keyStore.isKeyEntry(keyStoreAlias)) {
            throw new IllegalArgumentException("alias refers to a cert not a key: " + keyStoreAlias);
        }
        Key key = keyStore.getKey(keyStoreAlias, keyPassword);
        FileOutputStream os = new FileOutputStream(exportFile);
        os.write(key.getEncoded());
        os.close();
    }
}

