/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.xmlsig.elements;

import org.apache.tsik.domutil.DOMCursor;
import org.apache.tsik.domutil.DOMWriteCursor;
import org.apache.tsik.domutil.elements.ElementImpl;
import org.apache.tsik.util.Namespaces;

public class X509IssuerSerial
extends ElementImpl {
    protected static String name = "X509IssuerSerial";
    protected static String prefix = Namespaces.XMLSIG.getPrefix();
    protected static String uri = Namespaces.XMLSIG.getUri();
    protected static String[] ns = new String[]{prefix, uri};
    private static boolean DEBUG = false;
    private String issuerName = null;
    private String serialNumber = null;

    X509IssuerSerial(String issuerName, String serialNumber) {
        this.issuerName = issuerName;
        this.serialNumber = serialNumber;
    }

    public String getIssuerName() {
        return this.issuerName;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public String toString() {
        String s = "[X509IssuerSerial";
        if (this.issuerName != null) {
            s = s + " X509IssuerName=" + this.issuerName;
        }
        if (this.serialNumber != null) {
            s = s + " x509SerialNumber=" + this.serialNumber;
        }
        return s + "]";
    }

    public void toXml(DOMWriteCursor wc) {
        DOMWriteCursor wccc;
        DOMWriteCursor wcc = wc.addUnder(uri, prefix, name);
        if (this.issuerName != null) {
            wccc = wcc.addUnder(uri, prefix, "X509IssuerName");
            wccc.setText(this.issuerName);
        }
        if (this.serialNumber != null) {
            wccc = wcc.addUnder(uri, prefix, "X509SerialNumber");
            wccc.setText(this.serialNumber);
        }
    }

    public static boolean isAnElementIn(DOMCursor cursor) {
        try {
            DOMCursor c = X509IssuerSerial.placeCursor(cursor, name, prefix, uri, ns);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static X509IssuerSerial fromXml(DOMCursor cursor) {
        DOMCursor cc = X509IssuerSerial.placeCursor(cursor, name, prefix, uri, ns);
        String issuerName = null;
        String serialNumber = null;
        if (cc.moveToChild(uri, "X509IssuerName")) {
            issuerName = cc.getText();
            cc.moveToParent();
        }
        if (cc.moveToChild(uri, "X509SerialNumber")) {
            serialNumber = cc.getText();
            cc.moveToParent();
        }
        return new X509IssuerSerial(issuerName, serialNumber);
    }
}

