/*
 * Decompiled with CFR 0.152.
 */
package com.connsec.oidc.jose;

import com.google.common.base.Strings;
import com.nimbusds.jose.JWEAlgorithm;
import javax.persistence.Basic;
import javax.persistence.Embeddable;
import javax.persistence.Transient;

@Embeddable
public class JWEAlgorithmEmbed {
    public static final JWEAlgorithmEmbed NONE = JWEAlgorithmEmbed.getForAlgorithmName("none");
    private JWEAlgorithm algorithm;

    public JWEAlgorithmEmbed() {
    }

    public JWEAlgorithmEmbed(JWEAlgorithm algorithm) {
        this.algorithm = algorithm;
    }

    public static JWEAlgorithmEmbed getForAlgorithmName(String algorithmName) {
        JWEAlgorithmEmbed ent = new JWEAlgorithmEmbed();
        ent.setAlgorithmName(algorithmName);
        if (ent.getAlgorithm() == null) {
            return null;
        }
        return ent;
    }

    @Basic
    public String getAlgorithmName() {
        if (this.algorithm != null) {
            return this.algorithm.getName();
        }
        return null;
    }

    public void setAlgorithmName(String algorithmName) {
        this.algorithm = !Strings.isNullOrEmpty((String)algorithmName) ? JWEAlgorithm.parse((String)algorithmName) : null;
    }

    public String toString() {
        return "JWEAlgorithmEmbed [algorithm=" + this.algorithm + "]";
    }

    @Transient
    public JWEAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(JWEAlgorithm algorithm) {
        this.algorithm = algorithm;
    }
}

