/*
 * Decompiled with CFR 0.152.
 */
package com.connsec.client.oauth.extractors;

import com.connsec.client.oauth.exceptions.OAuthException;
import com.connsec.client.oauth.extractors.AccessTokenExtractor;
import com.connsec.client.oauth.model.Token;
import com.connsec.client.utils.JsonUtils;
import com.connsec.client.utils.Preconditions;

public class GsonJsonTokenExtractor
implements AccessTokenExtractor {
    public Token extract(String response) {
        System.out.println("extract a token from : " + response);
        Preconditions.checkEmptyString((String)response, (String)"Cannot extract a token from a null or empty String");
        try {
            Token token;
            try {
                token = (Token)JsonUtils.gson2Object((String)response, Token.class);
            }
            catch (Exception e) {
                token = (Token)JsonUtils.gson2Object((String)("{\"" + response.replace("&", "\",\"").replace("=", "\":\"") + "\"}"), Token.class);
            }
            if (token != null) {
                token.setRawResponse(response);
                token.setToken(token.getAccess_token());
            }
            return token;
        }
        catch (Exception e) {
            throw new OAuthException("Cannot extract an acces token. Response was: " + response);
        }
    }
}

