/*
 * Decompiled with CFR 0.152.
 */
package com.connsec.client.oauth.extractors;

import com.connsec.client.http.ParameterList;
import com.connsec.client.oauth.exceptions.OAuthParametersMissingException;
import com.connsec.client.oauth.extractors.BaseStringExtractor;
import com.connsec.client.oauth.model.OAuthRequest;
import com.connsec.client.utils.HttpEncoder;
import com.connsec.client.utils.Preconditions;

public class BaseStringExtractorImpl
implements BaseStringExtractor {
    private static final String AMPERSAND_SEPARATED_STRING = "%s&%s&%s";

    public String extract(OAuthRequest request) {
        this.checkPreconditions(request);
        String verb = HttpEncoder.encode((String)request.getVerb().name());
        String url = HttpEncoder.encode((String)request.getSanitizedUrl());
        String params = this.getSortedAndEncodedParams(request);
        return String.format(AMPERSAND_SEPARATED_STRING, verb, url, params);
    }

    private String getSortedAndEncodedParams(OAuthRequest request) {
        ParameterList params = new ParameterList();
        params.addAll(request.getQueryStringParams());
        params.addAll(request.getBodyParams());
        params.addAll(new ParameterList(request.getOauthParameters()));
        return params.sort().asOauthBaseString();
    }

    private void checkPreconditions(OAuthRequest request) {
        Preconditions.checkNotNull((Object)request, (String)"Cannot extract base string from null object");
        if (request.getOauthParameters() == null || request.getOauthParameters().size() <= 0) {
            throw new OAuthParametersMissingException(request);
        }
    }
}

