/*
 * Decompiled with CFR 0.152.
 */
package org.maxkey.client.oauth;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maxkey.client.http.AuthorizationHeader;
import org.maxkey.client.http.HttpVerb;
import org.maxkey.client.http.Response;
import org.maxkey.client.oauth.domain.OIDCUserInfo;
import org.maxkey.client.oauth.domain.UserInfo;
import org.maxkey.client.oauth.model.OAuthRequest;
import org.maxkey.client.oauth.model.Token;
import org.maxkey.client.utils.JsonUtils;
import org.maxkey.client.utils.Preconditions;

public class OAuthClient {
    private static Log log = LogFactory.getLog(OAuthClient.class);
    private static final String DEFAULT_WEB_URL = "http://sso.maxkey.org/maxkey";
    public static String OAUTH_V20_USERINFO_URI = "http://sso.maxkey.org/maxkey/api/oauth/v20/me";
    public static String OAUTH_V10A_USERINFO_URI = "http://sso.maxkey.org/maxkey/api/oauth/v10a/me";
    public static String OPENID_CONNECT_V10A_USERINFO_URI = "http://sso.maxkey.org/maxkey/api/connect/v10/userinfo";
    private HttpVerb method = HttpVerb.GET;
    private OAuthRequest request;

    public OAuthClient(String url) {
        Preconditions.checkEmptyString(url, "Invalid request url");
        this.request = new OAuthRequest(this.method, url);
    }

    public OAuthClient(String url, String accessToken) {
        Preconditions.checkEmptyString(url, "Invalid request url");
        this.request = new OAuthRequest(this.method, url);
        this.addParameter("access_token", accessToken);
    }

    public OAuthClient(String url, HttpVerb method) {
        Preconditions.checkEmptyString(url, "Invalid request url");
        if (method != null) {
            this.method = method;
        }
        this.request = new OAuthRequest(method, url);
    }

    public void signAccessToken(Token accessToken) {
        Preconditions.checkNotNull(this.request, "OAuthRequest is null");
        this.addParameter("access_token", accessToken.getToken());
    }

    public void addParameter(String name, String value) {
        Preconditions.checkEmptyString(name, "parameter name is null");
        Preconditions.checkNotNull(this.request, "OAuthRequest is null");
        if (HttpVerb.GET == this.method) {
            this.request.addQuerystringParameter(name, value);
        } else if (HttpVerb.POST == this.method) {
            this.request.addBodyParameter(name, value);
        }
    }

    public void addHeader(String name, String value) {
        Preconditions.checkEmptyString(name, "parameter name is null");
        Preconditions.checkNotNull(this.request, "OAuthRequest is null");
        this.request.addHeader(name, value);
    }

    public Response execute() {
        return this.request.send();
    }

    public Token requestAccessToken() {
        String tokenString = this.execute().getBody();
        Token token = JsonUtils.gson2Object(tokenString, Token.class);
        log.debug((Object)("Request token : " + token));
        return token;
    }

    public void addBasicAuthorization(String username, String password) {
        Preconditions.checkEmptyString(username, "parameter username is null");
        Preconditions.checkEmptyString(password, "parameter password is null");
        Preconditions.checkNotNull(this.request, "OAuthRequest is null");
        this.request.addHeader(AuthorizationHeader.AUTHORIZATION_HEADERNAME, AuthorizationHeader.createBasic(username, password));
    }

    public void addBearerAuthorization(String bearer) {
        Preconditions.checkEmptyString(bearer, "parameter bearer is null");
        Preconditions.checkNotNull(this.request, "OAuthRequest is null");
        this.request.addHeader(AuthorizationHeader.AUTHORIZATION_HEADERNAME, AuthorizationHeader.createBearer(bearer));
    }

    public UserInfo getUserInfo(String accessToken) {
        this.addParameter("access_token", accessToken);
        Response response = this.execute();
        log.debug((Object)("Request UserInfo : " + response.getBody()));
        UserInfo userInfo = JsonUtils.gson2Object(response.getBody(), UserInfo.class);
        userInfo.setResponseString(response.getBody());
        if (userInfo.getError() != null) {
            "".equals(userInfo.getError().trim());
        }
        log.debug((Object)("UserInfo : " + userInfo));
        return userInfo;
    }

    public OIDCUserInfo getOIDCUserInfo(String accessToken) {
        this.addHeader("Authorization", accessToken);
        Response response = this.execute();
        log.debug((Object)("Request OIDCUserInfo : " + response.getBody()));
        OIDCUserInfo userInfo = JsonUtils.gson2Object(response.getBody(), OIDCUserInfo.class);
        userInfo.setResponseString(response.getBody());
        if (userInfo.getError() != null) {
            "".equals(userInfo.getError().trim());
        }
        log.debug((Object)("UserInfo : " + userInfo));
        return userInfo;
    }

    public void addRestContent(String content) {
        this.request.addRestContent(content);
    }

    public void addRestObject(Object content) {
        this.request.addRestObject(content);
    }

    public void addRestContent(byte[] content) {
        this.request.addRestContent(content);
    }
}

