/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mybatis.jpa.dialect;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.mybatis.jpa.dialect.Dialect;
import org.apache.mybatis.jpa.persistence.JpaPagination;

public class DerbyDialect
extends Dialect {
    @Override
    public boolean supportsLimit() {
        return true;
    }

    @Override
    public String getLimitString(String sql, JpaPagination pagination) {
        StringBuilder pagingSelectSql = new StringBuilder(sql.length() + 50);
        pagingSelectSql.append(sql);
        if (pagination.getStartRow() == 0) {
            pagingSelectSql.append(" fetch first ");
        } else {
            pagingSelectSql.append(" offset ").append(pagination.getStartRow()).append(" rows fetch next ");
        }
        pagingSelectSql.append(pagination.getPageSize()).append(" rows only");
        return pagingSelectSql.toString();
    }

    @Override
    public String getPreparedStatementLimitString(String sql, JpaPagination pagination) {
        if (pagination.getPageSize() > 0 && pagination.getStartRow() > 0) {
            return String.valueOf(sql) + " LIMIT ? , ?";
        }
        if (pagination.getPageSize() > 0) {
            return String.valueOf(sql) + " LIMIT  ? ";
        }
        return String.valueOf(sql) + " LIMIT ?";
    }

    @Override
    public void setLimitParamters(PreparedStatement preparedStatement, int parameterSize, JpaPagination pagination) {
        try {
            if (pagination.getPageSize() > 0 && pagination.getStartRow() > 0) {
                preparedStatement.setInt(++parameterSize, pagination.getPageSize());
                preparedStatement.setInt(++parameterSize, pagination.getPageSize());
            } else if (pagination.getPageSize() > 0) {
                preparedStatement.setInt(++parameterSize, pagination.getPageSize());
            } else {
                preparedStatement.setInt(++parameterSize, 1000);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String toString() {
        return "DerbyDialect [" + DerbyDialect.class + "]";
    }
}

