/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.crypt.x509;

import edu.vt.middleware.crypt.x509.RDNSequenceIterator;
import edu.vt.middleware.crypt.x509.types.AttributeType;
import edu.vt.middleware.crypt.x509.types.AttributeTypeAndValue;
import edu.vt.middleware.crypt.x509.types.RelativeDistinguishedName;
import java.util.ArrayList;
import javax.security.auth.x500.X500Principal;

public final class DNUtils {
    private DNUtils() {
    }

    public static String[] getAttributeValues(X500Principal dn, AttributeType attribute) {
        return DNUtils.getAttributeValues(dn, attribute.getOid());
    }

    public static String[] getAttributeValues(X500Principal dn, String attributeOid) {
        RDNSequenceIterator rdnSeqIter = new RDNSequenceIterator(dn.getEncoded());
        ArrayList<String> values = new ArrayList<String>();
        for (RelativeDistinguishedName rdn : rdnSeqIter) {
            for (AttributeTypeAndValue atv : (AttributeTypeAndValue[])rdn.getItems()) {
                if (!atv.getType().equals(attributeOid)) continue;
                values.add(atv.getValue());
            }
        }
        return values.toArray(new String[values.size()]);
    }

    public static String getAttributeValue(X500Principal dn, AttributeType attribute) {
        return DNUtils.getAttributeValue(dn, attribute.getOid());
    }

    public static String getAttributeValue(X500Principal dn, String attributeOid) {
        RDNSequenceIterator rdnSeqIter = new RDNSequenceIterator(dn.getEncoded());
        for (RelativeDistinguishedName rdn : rdnSeqIter) {
            for (AttributeTypeAndValue atv : (AttributeTypeAndValue[])rdn.getItems()) {
                if (!atv.getType().equals(attributeOid)) continue;
                return atv.getValue();
            }
        }
        return null;
    }

    public static String getCN(X500Principal dn) {
        return DNUtils.getAttributeValue(dn, AttributeType.CommonName);
    }
}

