/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.crypt.tasks;

import edu.vt.middleware.crypt.CryptException;
import edu.vt.middleware.crypt.symmetric.SymmetricAlgorithm;
import edu.vt.middleware.crypt.util.CryptReader;
import edu.vt.middleware.crypt.util.HexConverter;
import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.Task;

public abstract class AbstractCryptTask
extends Task {
    protected String propertyName;
    protected String algorithm = "AES";
    protected String mode = "CBC";
    protected String padding = "PKCS5Padding";
    protected String iv;
    protected File privateKey;

    public void setName(String s) {
        this.propertyName = s;
    }

    public void setAlgorithm(String s) {
        this.algorithm = s;
    }

    public void setMode(String s) {
        this.mode = s;
    }

    public void setPadding(String s) {
        this.padding = s;
    }

    public void setIv(String s) {
        this.iv = s;
    }

    public void setPrivateKey(File f) {
        this.privateKey = f;
    }

    public abstract void execute();

    protected SymmetricAlgorithm createAlgorithm() throws CryptException, IOException {
        SymmetricAlgorithm crypt = SymmetricAlgorithm.newInstance(this.algorithm, this.mode, this.padding);
        if (this.iv != null) {
            crypt.setIV(new HexConverter().toBytes(this.iv));
        }
        crypt.setKey(CryptReader.readSecretKey(this.privateKey, this.algorithm));
        return crypt;
    }
}

