/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.signature;

import com.google.crypto.tink.PrivateKeyManager;
import com.google.crypto.tink.PublicKeySign;
import com.google.crypto.tink.proto.EcdsaKeyFormat;
import com.google.crypto.tink.proto.EcdsaParams;
import com.google.crypto.tink.proto.EcdsaPrivateKey;
import com.google.crypto.tink.proto.EcdsaPublicKey;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.signature.SigUtil;
import com.google.crypto.tink.subtle.EcdsaSignJce;
import com.google.crypto.tink.subtle.EllipticCurves;
import com.google.crypto.tink.subtle.Validators;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECPoint;

class EcdsaSignKeyManager
implements PrivateKeyManager<PublicKeySign> {
    public static final String TYPE_URL = "type.googleapis.com/google.crypto.tink.EcdsaPrivateKey";
    private static final int VERSION = 0;

    EcdsaSignKeyManager() {
    }

    @Override
    public PublicKeySign getPrimitive(ByteString serializedKey) throws GeneralSecurityException {
        try {
            EcdsaPrivateKey privKeyProto = EcdsaPrivateKey.parseFrom(serializedKey);
            return this.getPrimitive((MessageLite)privKeyProto);
        }
        catch (InvalidProtocolBufferException e) {
            throw new GeneralSecurityException("expected serialized EcdsaPrivateKey proto", e);
        }
    }

    @Override
    public PublicKeySign getPrimitive(MessageLite key) throws GeneralSecurityException {
        if (!(key instanceof EcdsaPrivateKey)) {
            throw new GeneralSecurityException("expected EcdsaPrivateKey proto");
        }
        EcdsaPrivateKey keyProto = (EcdsaPrivateKey)key;
        this.validateKey(keyProto);
        ECPrivateKey privateKey = EllipticCurves.getEcPrivateKey(SigUtil.toCurveType(keyProto.getPublicKey().getParams().getCurve()), keyProto.getKeyValue().toByteArray());
        return new EcdsaSignJce(privateKey, SigUtil.toHashType(keyProto.getPublicKey().getParams().getHashType()), SigUtil.toEcdsaEncoding(keyProto.getPublicKey().getParams().getEncoding()));
    }

    @Override
    public MessageLite newKey(ByteString serializedKeyFormat) throws GeneralSecurityException {
        try {
            EcdsaKeyFormat ecdsaKeyFormat = EcdsaKeyFormat.parseFrom(serializedKeyFormat);
            return this.newKey((MessageLite)ecdsaKeyFormat);
        }
        catch (InvalidProtocolBufferException e) {
            throw new GeneralSecurityException("expected EcdsaKeyFormat proto", e);
        }
    }

    @Override
    public MessageLite newKey(MessageLite keyFormat) throws GeneralSecurityException {
        if (!(keyFormat instanceof EcdsaKeyFormat)) {
            throw new GeneralSecurityException("expected EcdsaKeyFormat proto");
        }
        EcdsaKeyFormat format = (EcdsaKeyFormat)keyFormat;
        EcdsaParams ecdsaParams = format.getParams();
        SigUtil.validateEcdsaParams(ecdsaParams);
        KeyPair keyPair = EllipticCurves.generateKeyPair(SigUtil.toCurveType(ecdsaParams.getCurve()));
        ECPublicKey pubKey = (ECPublicKey)keyPair.getPublic();
        ECPrivateKey privKey = (ECPrivateKey)keyPair.getPrivate();
        ECPoint w = pubKey.getW();
        EcdsaPublicKey ecdsaPubKey = EcdsaPublicKey.newBuilder().setVersion(0).setParams(ecdsaParams).setX(ByteString.copyFrom((byte[])w.getAffineX().toByteArray())).setY(ByteString.copyFrom((byte[])w.getAffineY().toByteArray())).build();
        return EcdsaPrivateKey.newBuilder().setVersion(0).setPublicKey(ecdsaPubKey).setKeyValue(ByteString.copyFrom((byte[])privKey.getS().toByteArray())).build();
    }

    @Override
    public KeyData newKeyData(ByteString serializedKeyFormat) throws GeneralSecurityException {
        EcdsaPrivateKey key = (EcdsaPrivateKey)this.newKey(serializedKeyFormat);
        return KeyData.newBuilder().setTypeUrl(TYPE_URL).setValue(key.toByteString()).setKeyMaterialType(KeyData.KeyMaterialType.ASYMMETRIC_PRIVATE).build();
    }

    @Override
    public KeyData getPublicKeyData(ByteString serializedKey) throws GeneralSecurityException {
        try {
            EcdsaPrivateKey privKeyProto = EcdsaPrivateKey.parseFrom(serializedKey);
            return KeyData.newBuilder().setTypeUrl("type.googleapis.com/google.crypto.tink.EcdsaPublicKey").setValue(privKeyProto.getPublicKey().toByteString()).setKeyMaterialType(KeyData.KeyMaterialType.ASYMMETRIC_PUBLIC).build();
        }
        catch (InvalidProtocolBufferException e) {
            throw new GeneralSecurityException("expected serialized EcdsaPrivateKey proto", e);
        }
    }

    @Override
    public String getKeyType() {
        return TYPE_URL;
    }

    @Override
    public boolean doesSupport(String typeUrl) {
        return TYPE_URL.equals(typeUrl);
    }

    @Override
    public int getVersion() {
        return 0;
    }

    private void validateKey(EcdsaPrivateKey privKey) throws GeneralSecurityException {
        Validators.validateVersion(privKey.getVersion(), 0);
        SigUtil.validateEcdsaParams(privKey.getPublicKey().getParams());
    }
}

