/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.hybrid;

import com.google.crypto.tink.HybridEncrypt;
import com.google.crypto.tink.KeyManager;
import com.google.crypto.tink.hybrid.HybridUtil;
import com.google.crypto.tink.hybrid.RegistryEciesAeadHkdfDemHelper;
import com.google.crypto.tink.proto.EciesAeadHkdfParams;
import com.google.crypto.tink.proto.EciesAeadHkdfPublicKey;
import com.google.crypto.tink.proto.EciesHkdfKemParams;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.subtle.EciesAeadHkdfHybridEncrypt;
import com.google.crypto.tink.subtle.EllipticCurves;
import com.google.crypto.tink.subtle.Validators;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import java.security.GeneralSecurityException;
import java.security.interfaces.ECPublicKey;

class EciesAeadHkdfPublicKeyManager
implements KeyManager<HybridEncrypt> {
    private static final int VERSION = 0;
    public static final String TYPE_URL = "type.googleapis.com/google.crypto.tink.EciesAeadHkdfPublicKey";

    EciesAeadHkdfPublicKeyManager() {
    }

    @Override
    public HybridEncrypt getPrimitive(ByteString serializedKey) throws GeneralSecurityException {
        try {
            EciesAeadHkdfPublicKey recipientKeyProto = EciesAeadHkdfPublicKey.parseFrom(serializedKey);
            return this.getPrimitive((MessageLite)recipientKeyProto);
        }
        catch (InvalidProtocolBufferException e) {
            throw new GeneralSecurityException("expected serialized EciesAeadHkdfPublicKey proto", e);
        }
    }

    @Override
    public HybridEncrypt getPrimitive(MessageLite recipientKey) throws GeneralSecurityException {
        if (!(recipientKey instanceof EciesAeadHkdfPublicKey)) {
            throw new GeneralSecurityException("expected EciesAeadHkdfPublicKey proto");
        }
        EciesAeadHkdfPublicKey recipientKeyProto = (EciesAeadHkdfPublicKey)recipientKey;
        this.validate(recipientKeyProto);
        EciesAeadHkdfParams eciesParams = recipientKeyProto.getParams();
        EciesHkdfKemParams kemParams = eciesParams.getKemParams();
        ECPublicKey recipientPublicKey = EllipticCurves.getEcPublicKey(HybridUtil.toCurveType(kemParams.getCurveType()), recipientKeyProto.getX().toByteArray(), recipientKeyProto.getY().toByteArray());
        RegistryEciesAeadHkdfDemHelper demHelper = new RegistryEciesAeadHkdfDemHelper(eciesParams.getDemParams().getAeadDem());
        return new EciesAeadHkdfHybridEncrypt(recipientPublicKey, kemParams.getHkdfSalt().toByteArray(), HybridUtil.toHmacAlgo(kemParams.getHkdfHashType()), HybridUtil.toPointFormatType(eciesParams.getEcPointFormat()), demHelper);
    }

    @Override
    public MessageLite newKey(ByteString serializedKeyFormat) throws GeneralSecurityException {
        throw new GeneralSecurityException("Not implemented.");
    }

    @Override
    public MessageLite newKey(MessageLite keyFormat) throws GeneralSecurityException {
        throw new GeneralSecurityException("Not implemented.");
    }

    @Override
    public KeyData newKeyData(ByteString serializedKeyFormat) throws GeneralSecurityException {
        throw new GeneralSecurityException("Not implemented.");
    }

    @Override
    public boolean doesSupport(String typeUrl) {
        return TYPE_URL.equals(typeUrl);
    }

    @Override
    public String getKeyType() {
        return TYPE_URL;
    }

    @Override
    public int getVersion() {
        return 0;
    }

    private void validate(EciesAeadHkdfPublicKey key) throws GeneralSecurityException {
        Validators.validateVersion(key.getVersion(), 0);
        HybridUtil.validate(key.getParams());
    }
}

