/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.aead;

import com.google.crypto.tink.Aead;
import com.google.crypto.tink.KeyManager;
import com.google.crypto.tink.Mac;
import com.google.crypto.tink.Registry;
import com.google.crypto.tink.aead.AesCtrKeyManager;
import com.google.crypto.tink.proto.AesCtrHmacAeadKey;
import com.google.crypto.tink.proto.AesCtrHmacAeadKeyFormat;
import com.google.crypto.tink.proto.AesCtrKey;
import com.google.crypto.tink.proto.HmacKey;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.subtle.EncryptThenAuthenticate;
import com.google.crypto.tink.subtle.IndCpaCipher;
import com.google.crypto.tink.subtle.Validators;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import java.security.GeneralSecurityException;
import java.util.logging.Logger;

class AesCtrHmacAeadKeyManager
implements KeyManager<Aead> {
    private static final Logger logger = Logger.getLogger(AesCtrHmacAeadKeyManager.class.getName());
    private static final int VERSION = 0;
    public static final String TYPE_URL = "type.googleapis.com/google.crypto.tink.AesCtrHmacAeadKey";

    AesCtrHmacAeadKeyManager() throws GeneralSecurityException {
        Registry.registerKeyManager(new AesCtrKeyManager());
    }

    @Override
    public Aead getPrimitive(ByteString serializedKey) throws GeneralSecurityException {
        try {
            AesCtrHmacAeadKey keyProto = AesCtrHmacAeadKey.parseFrom(serializedKey);
            return this.getPrimitive((MessageLite)keyProto);
        }
        catch (InvalidProtocolBufferException e) {
            throw new GeneralSecurityException("expected serialized AesCtrHmacAeadKey proto", e);
        }
    }

    @Override
    public Aead getPrimitive(MessageLite key) throws GeneralSecurityException {
        if (!(key instanceof AesCtrHmacAeadKey)) {
            throw new GeneralSecurityException("expected AesCtrHmacAeadKey proto");
        }
        AesCtrHmacAeadKey keyProto = (AesCtrHmacAeadKey)key;
        this.validate(keyProto);
        return new EncryptThenAuthenticate((IndCpaCipher)Registry.getPrimitive("type.googleapis.com/google.crypto.tink.AesCtrKey", (MessageLite)keyProto.getAesCtrKey()), (Mac)Registry.getPrimitive("type.googleapis.com/google.crypto.tink.HmacKey", (MessageLite)keyProto.getHmacKey()), keyProto.getHmacKey().getParams().getTagSize());
    }

    @Override
    public MessageLite newKey(ByteString serializedKeyFormat) throws GeneralSecurityException {
        try {
            AesCtrHmacAeadKeyFormat format = AesCtrHmacAeadKeyFormat.parseFrom(serializedKeyFormat);
            return this.newKey((MessageLite)format);
        }
        catch (InvalidProtocolBufferException e) {
            throw new GeneralSecurityException("expected serialized AesCtrHmacAeadKeyFormat proto", e);
        }
    }

    @Override
    public MessageLite newKey(MessageLite keyFormat) throws GeneralSecurityException {
        if (!(keyFormat instanceof AesCtrHmacAeadKeyFormat)) {
            throw new GeneralSecurityException("expected AesCtrHmacAeadKeyFormat proto");
        }
        AesCtrHmacAeadKeyFormat format = (AesCtrHmacAeadKeyFormat)keyFormat;
        AesCtrKey aesCtrKey = (AesCtrKey)Registry.newKey("type.googleapis.com/google.crypto.tink.AesCtrKey", (MessageLite)format.getAesCtrKeyFormat());
        HmacKey hmacKey = (HmacKey)Registry.newKey("type.googleapis.com/google.crypto.tink.HmacKey", (MessageLite)format.getHmacKeyFormat());
        return AesCtrHmacAeadKey.newBuilder().setAesCtrKey(aesCtrKey).setHmacKey(hmacKey).setVersion(0).build();
    }

    @Override
    public KeyData newKeyData(ByteString serializedKeyFormat) throws GeneralSecurityException {
        AesCtrHmacAeadKey key = (AesCtrHmacAeadKey)this.newKey(serializedKeyFormat);
        return KeyData.newBuilder().setTypeUrl(TYPE_URL).setValue(key.toByteString()).setKeyMaterialType(KeyData.KeyMaterialType.SYMMETRIC).build();
    }

    @Override
    public boolean doesSupport(String typeUrl) {
        return typeUrl.equals(TYPE_URL);
    }

    @Override
    public String getKeyType() {
        return TYPE_URL;
    }

    @Override
    public int getVersion() {
        return 0;
    }

    private void validate(AesCtrHmacAeadKeyFormat format) throws GeneralSecurityException {
        Validators.validateAesKeySize(format.getAesCtrKeyFormat().getKeySize());
    }

    private void validate(AesCtrHmacAeadKey key) throws GeneralSecurityException {
        Validators.validateVersion(key.getVersion(), 0);
    }
}

