/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.log;

import net.jradius.log.RadiusLogger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Log4JRadiusLogger
implements RadiusLogger {
    private final Log log = LogFactory.getLog(this.getClass());

    public boolean isLoggable(int logLevel) {
        switch (logLevel) {
            case 0: {
                return true;
            }
            case 2: {
                return this.log.isErrorEnabled();
            }
            case 4: {
                return this.log.isWarnEnabled();
            }
            default: {
                return this.log.isInfoEnabled();
            }
            case 8: 
        }
        return this.log.isDebugEnabled();
    }

    public void error(String message) {
        if (message != null) {
            this.log.error((Object)message);
        }
    }

    public void error(String message, Throwable e) {
        if (message != null) {
            if (e != null) {
                this.log.error((Object)message, e);
            } else {
                this.log.error((Object)message);
            }
        } else if (e != null) {
            this.log.error((Object)"", e);
        }
    }

    public void warn(String message) {
        if (message != null) {
            this.log.warn((Object)message);
        }
    }

    public void warn(String message, Throwable e) {
        if (message != null) {
            if (e != null) {
                this.log.warn((Object)message, e);
            } else {
                this.log.warn((Object)message);
            }
        } else if (e != null) {
            this.log.warn((Object)"", e);
        }
    }

    public void info(String message) {
        if (message != null) {
            this.log.info((Object)message);
        }
    }

    public void info(String message, Throwable e) {
        if (message != null) {
            if (e != null) {
                this.log.info((Object)message, e);
            } else {
                this.log.info((Object)message);
            }
        } else if (e != null) {
            this.log.info((Object)"", e);
        }
    }

    public void debug(String message) {
        if (!this.log.isDebugEnabled()) {
            return;
        }
        if (message != null) {
            this.log.debug((Object)message);
        }
    }

    public void debug(String message, Throwable e) {
        if (!this.log.isDebugEnabled()) {
            return;
        }
        if (message != null) {
            if (e != null) {
                this.log.debug((Object)message, e);
            } else {
                this.log.debug((Object)message);
            }
        } else if (e != null) {
            this.log.debug((Object)"", e);
        }
    }
}

