/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.freeradius;

import java.io.IOException;
import java.nio.ByteBuffer;
import net.jradius.log.RadiusLog;
import net.jradius.packet.Format;
import net.jradius.packet.RadiusFormat;
import net.jradius.packet.RadiusPacket;
import net.jradius.packet.attribute.AttributeList;
import net.jradius.packet.attribute.RadiusAttribute;
import net.jradius.packet.attribute.VSAWithSubAttributes;
import net.jradius.packet.attribute.value.AttributeValue;

public class FreeRadiusFormat
extends RadiusFormat {
    private static final FreeRadiusFormat staticFormat = new FreeRadiusFormat();

    public static void setAttributeBytes(RadiusPacket p, ByteBuffer buffer, int length) {
        staticFormat.unpackAttributes(p.getAttributes(), buffer, length);
    }

    public void packAttribute(ByteBuffer buffer, RadiusAttribute a) {
        if (a instanceof VSAWithSubAttributes) {
            VSAWithSubAttributes sa = (VSAWithSubAttributes)a;
            AttributeList subList = sa.getSubAttributes();
            for (RadiusAttribute ra : subList.getAttributeList()) {
                try {
                    super.packAttribute(buffer, ra);
                }
                catch (Exception e) {
                    RadiusLog.warn(e.getMessage(), e);
                }
            }
        } else {
            try {
                super.packAttribute(buffer, a);
            }
            catch (Exception e) {
                RadiusLog.warn(e.getMessage(), e);
            }
        }
    }

    public void packHeader(ByteBuffer buffer, RadiusPacket p, int attributesLength, String sharedSecret) {
        FreeRadiusFormat.putUnsignedInt(buffer, p.getCode());
        FreeRadiusFormat.putUnsignedInt(buffer, p.getIdentifier());
        FreeRadiusFormat.putUnsignedInt(buffer, attributesLength);
    }

    public void packPacket(RadiusPacket packet, String sharedSecret, ByteBuffer buffer, boolean onWire) throws IOException {
        if (packet == null) {
            throw new IllegalArgumentException("Packet is null.");
        }
        int initialPosition = buffer.position();
        buffer.position(initialPosition + 12);
        this.packAttributeList(packet.getAttributes(), buffer, onWire);
        int finalPosition = buffer.position();
        int totalLength = finalPosition - initialPosition;
        int attributesLength = totalLength - 12;
        try {
            buffer.position(initialPosition);
            this.packHeader(buffer, packet, attributesLength, sharedSecret);
            buffer.position(finalPosition);
        }
        catch (Exception e) {
            RadiusLog.warn(e.getMessage(), e);
        }
    }

    public void packHeader(ByteBuffer buffer, RadiusAttribute a) {
        AttributeValue attributeValue = a.getValue();
        FreeRadiusFormat.putUnsignedInt(buffer, a.getFormattedType());
        FreeRadiusFormat.putUnsignedInt(buffer, attributeValue.getLength());
        FreeRadiusFormat.putUnsignedInt(buffer, a.getAttributeOp());
    }

    public void unpackAttributeHeader(ByteBuffer buffer, Format.AttributeParseContext ctx) throws IOException {
        ctx.attributeOp = 0L;
        ctx.vendorNumber = -1;
        ctx.padding = 0;
        ctx.attributeType = FreeRadiusFormat.getUnsignedInt(buffer);
        ctx.attributeLength = FreeRadiusFormat.getUnsignedInt(buffer) + 12L;
        ctx.attributeOp = FreeRadiusFormat.getUnsignedInt(buffer);
        ctx.headerLength = 12;
        if (ctx.attributeType > 65536L) {
            ctx.vendorNumber = (int)(ctx.attributeType >> 16 & 0xFFFFL);
            ctx.attributeType &= 0xFFFFL;
        }
    }
}

