/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.client.auth;

import net.jradius.client.auth.RadiusAuthenticator;
import net.jradius.exception.RadiusException;
import net.jradius.packet.RadiusPacket;
import net.jradius.packet.attribute.AttributeFactory;
import net.jradius.packet.attribute.RadiusAttribute;
import net.jradius.util.MSCHAP;
import net.jradius.util.RadiusRandom;

public class MSCHAPv1Authenticator
extends RadiusAuthenticator {
    public static final String NAME = "mschapv1";

    public String getAuthName() {
        return NAME;
    }

    public void processRequest(RadiusPacket p) throws RadiusException {
        p.removeAttribute(this.password);
        byte[] authChallenge = RadiusRandom.getBytes(16);
        byte[] chapResponse = MSCHAP.doMSCHAPv1(this.password.getValue().getBytes(), authChallenge);
        RadiusAttribute attr = AttributeFactory.newAttribute("MS-CHAP-Challenge");
        p.addAttribute(attr);
        attr.setValue(authChallenge);
        attr = AttributeFactory.newAttribute("MS-CHAP-Response");
        p.addAttribute(attr);
        attr.setValue(chapResponse);
    }
}

