/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.client;

import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import net.jradius.client.RadiusClient;
import net.jradius.client.TransportStatusListener;
import net.jradius.exception.RadiusException;
import net.jradius.exception.RadiusSecurityException;
import net.jradius.exception.TimeoutException;
import net.jradius.log.RadiusLog;
import net.jradius.packet.AccessRequest;
import net.jradius.packet.RadiusPacket;
import net.jradius.packet.RadiusRequest;
import net.jradius.packet.RadiusResponse;
import net.jradius.util.MessageAuthenticator;

public abstract class RadiusClientTransport {
    protected InetAddress localInetAddress;
    protected InetAddress remoteInetAddress;
    protected String sharedSecret;
    protected int authPort;
    protected int acctPort;
    public static final int defaultTimeout = 60;
    protected int socketTimeout = 60000;
    protected RadiusClient radiusClient;
    protected TransportStatusListener statusListener;

    protected abstract void send(RadiusRequest var1, int var2) throws Exception;

    protected abstract RadiusResponse receive(RadiusRequest var1) throws Exception;

    public abstract void close();

    public RadiusResponse sendReceive(RadiusRequest p, int retries) throws RadiusException {
        RadiusResponse r = null;
        int tries = 0;
        if (p instanceof AccessRequest) {
            try {
                this.generateMessageAuthenticator(p);
            }
            catch (IOException e) {
                throw new RadiusException(e);
            }
        }
        if (retries < 0) {
            retries = 0;
        }
        ++retries;
        while (tries < retries) {
            try {
                this.send(p, tries);
                r = this.receive(p);
                break;
            }
            catch (SocketTimeoutException e) {
            }
            catch (IOException e) {
                RadiusLog.warn("Unable to send or receive radius packet", e);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++tries;
        }
        if (tries == retries) {
            throw new TimeoutException("Timeout: No Response from RADIUS Server");
        }
        if (!this.verifyAuthenticator(p, r)) {
            throw new RadiusSecurityException("Invalid RADIUS Authenticator");
        }
        if (!this.verifyMessageAuthenticator(p, r, r.findAttribute(79L) != null)) {
            throw new RadiusSecurityException("Invalid RADIUS Message-Authenticator");
        }
        return r;
    }

    protected void generateMessageAuthenticator(RadiusPacket request) throws IOException {
        MessageAuthenticator.generateRequestMessageAuthenticator(request, this.sharedSecret);
    }

    public boolean verifyMessageAuthenticator(RadiusRequest request, RadiusResponse reply, boolean required) {
        return RadiusClientTransport.verifyMessageAuthenticator(request, reply, this.sharedSecret, required);
    }

    public static boolean verifyMessageAuthenticator(RadiusRequest request, RadiusResponse reply, String sharedSecret, boolean required) {
        return RadiusClientTransport.verifyMessageAuthenticator(request.getAuthenticator(), reply, sharedSecret, required);
    }

    public static boolean verifyMessageAuthenticator(byte[] requestAuth, RadiusResponse reply, String sharedSecret, boolean required) {
        try {
            Boolean verified = MessageAuthenticator.verifyReply(requestAuth, reply, sharedSecret);
            if (verified == null && required) {
                return false;
            }
            if (verified == null) {
                return true;
            }
            return verified;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean verifyAuthenticator(RadiusRequest request, RadiusResponse reply) {
        return reply.verifyAuthenticator(request.getAuthenticator(), this.getSharedSecret());
    }

    public static boolean verifyAuthenticator(RadiusRequest request, RadiusResponse reply, String sharedSecret) {
        return reply.verifyAuthenticator(request.getAuthenticator(), sharedSecret);
    }

    public static boolean verifyAuthenticator(byte[] requestAuth, RadiusResponse reply, String sharedSecret) {
        return reply.verifyAuthenticator(requestAuth, sharedSecret);
    }

    public InetAddress getRemoteInetAddress() {
        return this.remoteInetAddress;
    }

    public void setRemoteInetAddress(InetAddress remoteInetAddress) {
        this.remoteInetAddress = remoteInetAddress;
    }

    public InetAddress getLocalInetAddress() {
        return this.localInetAddress;
    }

    public void setLocalInetAddress(InetAddress localInetAddress) {
        this.localInetAddress = localInetAddress;
    }

    public String getSharedSecret() {
        return this.sharedSecret;
    }

    public void setSharedSecret(String sharedSecret) {
        this.sharedSecret = sharedSecret;
    }

    public int getAuthPort() {
        return this.authPort;
    }

    public void setAuthPort(int authPort) {
        this.authPort = authPort;
    }

    public int getAcctPort() {
        return this.acctPort;
    }

    public void setAcctPort(int acctPort) {
        this.acctPort = acctPort;
    }

    public int getSocketTimeout() {
        return this.socketTimeout / 1000;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout * 1000;
    }

    public RadiusClient getRadiusClient() {
        return this.radiusClient;
    }

    public void setRadiusClient(RadiusClient radiusClient) {
        this.radiusClient = radiusClient;
    }

    public void setStatusListener(TransportStatusListener statusListener) {
        this.statusListener = statusListener;
    }
}

