/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.ws.wssecurity.impl;

import java.util.Collections;
import java.util.List;
import org.opensaml.ws.wssecurity.EncryptedHeader;
import org.opensaml.ws.wssecurity.impl.AbstractWSSecurityObject;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.encryption.EncryptedData;
import org.opensaml.xml.schema.XSBooleanValue;
import org.opensaml.xml.util.LazyList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncryptedHeaderImpl
extends AbstractWSSecurityObject
implements EncryptedHeader {
    private EncryptedData encryptedData;
    private String wsuId;
    private XSBooleanValue soap11MustUnderstand;
    private String soap11Actor;
    private XSBooleanValue soap12MustUnderstand;
    private String soap12Role;
    private XSBooleanValue soap12Relay;

    public EncryptedHeaderImpl(String namespaceURI, String elementLocalName, String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    @Override
    public EncryptedData getEncryptedData() {
        return this.encryptedData;
    }

    @Override
    public void setEncryptedData(EncryptedData newEncryptedData) {
        this.encryptedData = (EncryptedData)this.prepareForAssignment((XMLObject)this.encryptedData, (XMLObject)newEncryptedData);
    }

    @Override
    public String getWSUId() {
        return this.wsuId;
    }

    @Override
    public void setWSUId(String newId) {
        String oldId = this.wsuId;
        this.wsuId = this.prepareForAssignment(this.wsuId, newId);
        this.registerOwnID(oldId, this.wsuId);
    }

    @Override
    public Boolean isSOAP11MustUnderstand() {
        if (this.soap11MustUnderstand != null) {
            return this.soap11MustUnderstand.getValue();
        }
        return Boolean.FALSE;
    }

    @Override
    public XSBooleanValue isSOAP11MustUnderstandXSBoolean() {
        return this.soap11MustUnderstand;
    }

    @Override
    public void setSOAP11MustUnderstand(Boolean newMustUnderstand) {
        this.soap11MustUnderstand = newMustUnderstand != null ? (XSBooleanValue)this.prepareForAssignment(this.soap11MustUnderstand, new XSBooleanValue(newMustUnderstand, true)) : (XSBooleanValue)this.prepareForAssignment(this.soap11MustUnderstand, null);
    }

    @Override
    public void setSOAP11MustUnderstand(XSBooleanValue newMustUnderstand) {
        this.soap11MustUnderstand = (XSBooleanValue)this.prepareForAssignment(this.soap11MustUnderstand, newMustUnderstand);
    }

    @Override
    public String getSOAP11Actor() {
        return this.soap11Actor;
    }

    @Override
    public void setSOAP11Actor(String newActor) {
        this.soap11Actor = this.prepareForAssignment(this.soap11Actor, newActor);
    }

    @Override
    public Boolean isSOAP12MustUnderstand() {
        if (this.soap12MustUnderstand != null) {
            return this.soap12MustUnderstand.getValue();
        }
        return Boolean.FALSE;
    }

    @Override
    public XSBooleanValue isSOAP12MustUnderstandXSBoolean() {
        return this.soap12MustUnderstand;
    }

    @Override
    public void setSOAP12MustUnderstand(Boolean newMustUnderstand) {
        this.soap12MustUnderstand = newMustUnderstand != null ? (XSBooleanValue)this.prepareForAssignment(this.soap12MustUnderstand, new XSBooleanValue(newMustUnderstand, false)) : (XSBooleanValue)this.prepareForAssignment(this.soap12MustUnderstand, null);
    }

    @Override
    public void setSOAP12MustUnderstand(XSBooleanValue newMustUnderstand) {
        this.soap12MustUnderstand = (XSBooleanValue)this.prepareForAssignment(this.soap12MustUnderstand, newMustUnderstand);
    }

    @Override
    public String getSOAP12Role() {
        return this.soap12Role;
    }

    @Override
    public void setSOAP12Role(String newRole) {
        this.soap12Role = this.prepareForAssignment(this.soap12Role, newRole);
    }

    @Override
    public Boolean isSOAP12Relay() {
        if (this.soap12Relay != null) {
            return this.soap12Relay.getValue();
        }
        return Boolean.FALSE;
    }

    @Override
    public XSBooleanValue isSOAP12RelayXSBoolean() {
        return this.soap12Relay;
    }

    @Override
    public void setSOAP12Relay(Boolean newRelay) {
        this.soap12Relay = newRelay != null ? (XSBooleanValue)this.prepareForAssignment(this.soap12Relay, new XSBooleanValue(newRelay, false)) : (XSBooleanValue)this.prepareForAssignment(this.soap12Relay, null);
    }

    @Override
    public void setSOAP12Relay(XSBooleanValue newRelay) {
        this.soap12Relay = (XSBooleanValue)this.prepareForAssignment(this.soap12Relay, newRelay);
    }

    @Override
    public List<XMLObject> getOrderedChildren() {
        LazyList children = new LazyList();
        if (this.encryptedData != null) {
            children.add((Object)this.encryptedData);
        }
        return Collections.unmodifiableList(children);
    }
}

