/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.ws.message.decoder;

import java.io.InputStream;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.message.decoder.MessageDecoder;
import org.opensaml.ws.message.decoder.MessageDecodingException;
import org.opensaml.ws.security.SecurityPolicy;
import org.opensaml.ws.security.SecurityPolicyResolver;
import org.opensaml.xml.Configuration;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.Unmarshaller;
import org.opensaml.xml.io.UnmarshallingException;
import org.opensaml.xml.parse.BasicParserPool;
import org.opensaml.xml.parse.ParserPool;
import org.opensaml.xml.parse.XMLParserException;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class BaseMessageDecoder
implements MessageDecoder {
    private Logger protocolMessageLog = LoggerFactory.getLogger((String)"PROTOCOL_MESSAGE");
    private final Logger log = LoggerFactory.getLogger(BaseMessageDecoder.class);
    private ParserPool parserPool;

    public BaseMessageDecoder() {
        this.parserPool = new BasicParserPool();
    }

    public BaseMessageDecoder(ParserPool pool) {
        if (pool == null) {
            throw new IllegalArgumentException("Parser pool may not be null");
        }
        this.parserPool = pool;
    }

    public void decode(MessageContext messageContext) throws MessageDecodingException, SecurityException {
        this.log.debug("Beginning to decode message from inbound transport of type: {}", (Object)messageContext.getInboundMessageTransport().getClass().getName());
        this.doDecode(messageContext);
        this.logDecodedMessage(messageContext);
        this.processSecurityPolicy(messageContext);
        this.log.debug("Successfully decoded message.");
    }

    protected void logDecodedMessage(MessageContext messageContext) {
        if (this.protocolMessageLog.isDebugEnabled() && messageContext.getInboundMessage() != null) {
            this.protocolMessageLog.debug("\n" + XMLHelper.prettyPrintXML((Node)messageContext.getInboundMessage().getDOM()));
        }
    }

    protected void processSecurityPolicy(MessageContext messageContext) throws SecurityException {
        SecurityPolicyResolver policyResolver = messageContext.getSecurityPolicyResolver();
        if (policyResolver != null) {
            Iterable securityPolicies = policyResolver.resolve(messageContext);
            if (securityPolicies != null) {
                for (SecurityPolicy policy : securityPolicies) {
                    if (policy == null) continue;
                    this.log.debug("Evaluating security policy of type '{}' for decoded message", (Object)policy.getClass().getName());
                    policy.evaluate(messageContext);
                }
            } else {
                this.log.debug("No security policy resolved for this message context, no security policy evaluation attempted");
            }
        } else {
            this.log.debug("No security policy resolver attached to this message context, no security policy evaluation attempted");
        }
    }

    protected abstract void doDecode(MessageContext var1) throws MessageDecodingException;

    protected ParserPool getParserPool() {
        return this.parserPool;
    }

    protected void setParserPool(ParserPool pool) {
        if (pool == null) {
            throw new IllegalArgumentException("Parser pool may not be null");
        }
        this.parserPool = pool;
    }

    protected XMLObject unmarshallMessage(InputStream messageStream) throws MessageDecodingException {
        this.log.debug("Parsing message stream into DOM document");
        try {
            Document messageDoc = this.parserPool.parse(messageStream);
            Element messageElem = messageDoc.getDocumentElement();
            if (this.log.isTraceEnabled()) {
                this.log.trace("Resultant DOM message was:\n{}", (Object)XMLHelper.nodeToString((Node)messageElem));
            }
            this.log.debug("Unmarshalling message DOM");
            Unmarshaller unmarshaller = Configuration.getUnmarshallerFactory().getUnmarshaller(messageElem);
            if (unmarshaller == null) {
                this.log.error("Unable to unmarshall message, no unmarshaller registered for message element " + XMLHelper.getNodeQName((Node)messageElem));
                throw new MessageDecodingException("Unable to unmarshall message, no unmarshaller registered for message element " + XMLHelper.getNodeQName((Node)messageElem));
            }
            XMLObject message = unmarshaller.unmarshall(messageElem);
            this.log.debug("Message succesfully unmarshalled");
            return message;
        }
        catch (XMLParserException e) {
            this.log.error("Encountered error parsing message into its DOM representation", (Throwable)e);
            throw new MessageDecodingException("Encountered error parsing message into its DOM representation", (Exception)((Object)e));
        }
        catch (UnmarshallingException e) {
            this.log.error("Encountered error unmarshalling message from its DOM representation", (Throwable)e);
            throw new MessageDecodingException("Encountered error unmarshalling message from its DOM representation", (Exception)((Object)e));
        }
    }
}

