/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.metadata.provider;

import org.opensaml.saml2.metadata.provider.AbstractObservableMetadataProvider;
import org.opensaml.saml2.metadata.provider.FilterException;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.Unmarshaller;
import org.opensaml.xml.io.UnmarshallingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class DOMMetadataProvider
extends AbstractObservableMetadataProvider
implements MetadataProvider {
    private final Logger log = LoggerFactory.getLogger(DOMMetadataProvider.class);
    private Element metadataElement;
    private XMLObject metadata;

    public DOMMetadataProvider(Element mdElement) {
        this.metadataElement = mdElement;
    }

    public XMLObject getMetadata() {
        return this.metadata;
    }

    public synchronized void initialize() throws MetadataProviderException {
        this.refreshMetadata();
    }

    private synchronized void refreshMetadata() throws MetadataProviderException {
        try {
            Unmarshaller unmarshaller = this.unmarshallerFactory.getUnmarshaller(this.metadataElement);
            XMLObject metadataTemp = unmarshaller.unmarshall(this.metadataElement);
            this.filterMetadata(metadataTemp);
            this.releaseMetadataDOM(metadataTemp);
            this.metadata = metadataTemp;
            this.emitChangeEvent();
        }
        catch (UnmarshallingException e) {
            String errorMsg = "Unable to unmarshall metadata element";
            this.log.error(errorMsg, (Throwable)e);
            throw new MetadataProviderException(errorMsg, (Exception)((Object)e));
        }
        catch (FilterException e) {
            String errorMsg = "Unable to filter metadata";
            this.log.error(errorMsg, (Throwable)e);
            throw new MetadataProviderException(errorMsg, e);
        }
    }
}

