/*
 * Decompiled with CFR 0.152.
 */
package com.connsec.client.http;

import com.connsec.client.http.AuthorizationHeader;
import com.connsec.client.http.HttpVerb;
import com.connsec.client.http.Request;
import com.connsec.client.http.Response;
import com.connsec.client.utils.Preconditions;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RestClient {
    private static Log _log = LogFactory.getLog(RestClient.class);
    private HttpVerb method = HttpVerb.GET;
    private Request request;

    public RestClient(String url) {
        Preconditions.checkEmptyString((String)url, (String)"Invalid request url");
        this.request = new Request(this.method, url);
    }

    public RestClient(String url, HttpVerb method) {
        Preconditions.checkEmptyString((String)url, (String)"Invalid request url");
        if (method != null) {
            this.method = method;
        }
        this.request = new Request(method, url);
    }

    public void addParameter(String name, String value) {
        Preconditions.checkEmptyString((String)name, (String)"parameter name is null");
        Preconditions.checkNotNull((Object)this.request, (String)"RestClient is null");
        if (HttpVerb.GET == this.method) {
            this.request.addQuerystringParameter(name, value);
        } else if (HttpVerb.POST == this.method) {
            this.request.addBodyParameter(name, value);
        }
    }

    public void addHeader(String name, String value) {
        Preconditions.checkEmptyString((String)name, (String)"parameter name is null");
        Preconditions.checkNotNull((Object)this.request, (String)"OAuthRequest is null");
        this.request.addHeader(name, value);
    }

    public Response execute() {
        return this.request.send();
    }

    public void addBasicAuthorization(String username, String password) {
        Preconditions.checkEmptyString((String)username, (String)"parameter username is null");
        Preconditions.checkEmptyString((String)password, (String)"parameter password is null");
        Preconditions.checkNotNull((Object)this.request, (String)"RestClient is null");
        this.request.addHeader(AuthorizationHeader.AUTHORIZATION_HEADERNAME, AuthorizationHeader.createBasic((String)username, (String)password));
    }

    public void addBearerAuthorization(String bearer) {
        Preconditions.checkEmptyString((String)bearer, (String)"parameter bearer is null");
        Preconditions.checkNotNull((Object)this.request, (String)"RestClient is null");
        this.request.addHeader(AuthorizationHeader.AUTHORIZATION_HEADERNAME, AuthorizationHeader.createBearer((String)bearer));
    }

    public void addRestContent(String content) {
        this.request.addRestContent(content);
    }

    public void addRestObject(Object content) {
        this.request.addRestObject(content);
    }

    public void addRestContent(byte[] content) {
        this.request.addRestContent(content);
    }
}

