/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose;

import net.jcip.annotations.Immutable;
import net.minidev.json.JSONAware;
import net.minidev.json.JSONObject;

@Immutable
public final class JOSEObjectType
implements JSONAware {
    public static final JOSEObjectType JWS = new JOSEObjectType("JWS");
    public static final JOSEObjectType JWE = new JOSEObjectType("JWE");
    private final String type;

    public JOSEObjectType(String type) {
        if (type == null) {
            throw new IllegalArgumentException("The object type must not be null");
        }
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public boolean equals(Object object) {
        return object != null && object instanceof JOSEObjectType && this.toString().equals(object.toString());
    }

    public String toString() {
        return this.type;
    }

    public String toJSONString() {
        StringBuilder sb = new StringBuilder();
        sb.append('\"');
        sb.append(JSONObject.escape(this.type));
        sb.append('\"');
        return sb.toString();
    }
}

