/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.Requirement;
import net.jcip.annotations.Immutable;

@Immutable
public final class EncryptionMethod
extends Algorithm {
    public static final EncryptionMethod A128CBC_HS256 = new EncryptionMethod("A128CBC+HS256", Requirement.REQUIRED);
    public static final EncryptionMethod A256CBC_HS512 = new EncryptionMethod("A256CBC+HS512", Requirement.REQUIRED);
    public static final EncryptionMethod A128GCM = new EncryptionMethod("A128GCM", Requirement.RECOMMENDED);
    public static final EncryptionMethod A256GCM = new EncryptionMethod("A256GCM", Requirement.RECOMMENDED);

    public EncryptionMethod(String name, Requirement req) {
        super(name, req);
    }

    public EncryptionMethod(String name) {
        super(name, null);
    }

    public static EncryptionMethod parse(String s) {
        if (s == A128CBC_HS256.getName()) {
            return A128CBC_HS256;
        }
        if (s == A256CBC_HS512.getName()) {
            return A256CBC_HS512;
        }
        if (s == A128GCM.getName()) {
            return A128GCM;
        }
        if (s == A256GCM.getName()) {
            return A256GCM;
        }
        return new EncryptionMethod(s);
    }
}

