/*
 * Decompiled with CFR 0.152.
 */
package org.maxkey.authz.oauth2.provider.token;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.maxkey.authz.oauth2.common.DefaultOAuth2AccessToken;
import org.maxkey.authz.oauth2.common.OAuth2AccessToken;
import org.maxkey.authz.oauth2.provider.OAuth2Authentication;
import org.maxkey.authz.oauth2.provider.OAuth2Request;
import org.maxkey.authz.oauth2.provider.token.AccessTokenConverter;
import org.maxkey.authz.oauth2.provider.token.DefaultUserAuthenticationConverter;
import org.maxkey.authz.oauth2.provider.token.UserAuthenticationConverter;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;

public class DefaultAccessTokenConverter
implements AccessTokenConverter {
    private UserAuthenticationConverter userTokenConverter = new DefaultUserAuthenticationConverter();
    private boolean includeGrantType;

    public void setUserTokenConverter(UserAuthenticationConverter userTokenConverter) {
        this.userTokenConverter = userTokenConverter;
    }

    public void setIncludeGrantType(boolean includeGrantType) {
        this.includeGrantType = includeGrantType;
    }

    @Override
    public Map<String, ?> convertAccessToken(OAuth2AccessToken token, OAuth2Authentication authentication) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        OAuth2Request clientToken = authentication.getOAuth2Request();
        if (!authentication.isClientOnly()) {
            response.putAll(this.userTokenConverter.convertUserAuthentication(authentication.getUserAuthentication()));
        } else if (clientToken.getAuthorities() != null && !clientToken.getAuthorities().isEmpty()) {
            response.put("authorities", AuthorityUtils.authorityListToSet(clientToken.getAuthorities()));
        }
        if (token.getScope() != null) {
            response.put("scope", token.getScope());
        }
        if (token.getAdditionalInformation().containsKey("jti")) {
            response.put("jti", token.getAdditionalInformation().get("jti"));
        }
        if (token.getExpiration() != null) {
            response.put("exp", token.getExpiration().getTime() / 1000L);
        }
        if (this.includeGrantType && authentication.getOAuth2Request().getGrantType() != null) {
            response.put("grant_type", authentication.getOAuth2Request().getGrantType());
        }
        response.putAll(token.getAdditionalInformation());
        response.put("client_id", clientToken.getClientId());
        if (clientToken.getResourceIds() != null && !clientToken.getResourceIds().isEmpty()) {
            response.put("aud", clientToken.getResourceIds());
        }
        return response;
    }

    @Override
    public OAuth2AccessToken extractAccessToken(String value, Map<String, ?> map) {
        Collection scope;
        DefaultOAuth2AccessToken token = new DefaultOAuth2AccessToken(value);
        HashMap<String, Object> info = new HashMap<String, Object>(map);
        info.remove("exp");
        info.remove("aud");
        info.remove("client_id");
        info.remove("scope");
        if (map.containsKey("exp")) {
            token.setExpiration(new Date((Long)map.get("exp") * 1000L));
        }
        if (map.containsKey("jti")) {
            info.put("jti", map.get("jti"));
        }
        if ((scope = (Collection)map.get("scope")) != null) {
            token.setScope(new HashSet<String>(scope));
        }
        token.setAdditionalInformation(info);
        return token;
    }

    @Override
    public OAuth2Authentication extractAuthentication(Map<String, ?> map) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        LinkedHashSet<String> scope = new LinkedHashSet<String>(map.containsKey("scope") ? (Collection)map.get("scope") : Collections.emptySet());
        Authentication user = this.userTokenConverter.extractAuthentication(map);
        String clientId = (String)map.get("client_id");
        parameters.put("client_id", clientId);
        if (this.includeGrantType && map.containsKey("grant_type")) {
            parameters.put("grant_type", (String)map.get("grant_type"));
        }
        LinkedHashSet<String> resourceIds = new LinkedHashSet<String>(map.containsKey("aud") ? (Collection)map.get("aud") : Collections.emptySet());
        List authorities = null;
        if (user == null && map.containsKey("authorities")) {
            String[] roles = ((Collection)map.get("authorities")).toArray(new String[0]);
            authorities = AuthorityUtils.createAuthorityList((String[])roles);
        }
        OAuth2Request request = new OAuth2Request(parameters, clientId, authorities, true, scope, resourceIds, null, null, null);
        return new OAuth2Authentication(request, user);
    }
}

