/*
 * Decompiled with CFR 0.152.
 */
package org.maxkey.authz.oauth2.provider.request;

import java.util.Set;
import org.maxkey.authz.oauth2.common.exceptions.InvalidScopeException;
import org.maxkey.authz.oauth2.provider.AuthorizationRequest;
import org.maxkey.authz.oauth2.provider.OAuth2RequestValidator;
import org.maxkey.authz.oauth2.provider.TokenRequest;
import org.maxkey.domain.apps.oauth2.provider.ClientDetails;

public class DefaultOAuth2RequestValidator
implements OAuth2RequestValidator {
    @Override
    public void validateScope(AuthorizationRequest authorizationRequest, ClientDetails client) throws InvalidScopeException {
        this.validateScope(authorizationRequest.getScope(), client.getScope());
    }

    @Override
    public void validateScope(TokenRequest tokenRequest, ClientDetails client) throws InvalidScopeException {
        this.validateScope(tokenRequest.getScope(), client.getScope());
    }

    private void validateScope(Set<String> requestScopes, Set<String> clientScopes) {
        if (clientScopes != null && !clientScopes.isEmpty()) {
            for (String scope : requestScopes) {
                if (clientScopes.contains(scope)) continue;
                throw new InvalidScopeException("Invalid scope: " + scope, clientScopes);
            }
        }
        if (requestScopes.isEmpty()) {
            throw new InvalidScopeException("Empty scope (either the client or the user is not allowed the requested scopes)");
        }
    }
}

