/*
 * Decompiled with CFR 0.152.
 */
package org.maxkey.authz.oauth2.provider.endpoint;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maxkey.authz.oauth2.provider.ClientDetailsService;
import org.maxkey.authz.oauth2.provider.CompositeTokenGranter;
import org.maxkey.authz.oauth2.provider.OAuth2RequestFactory;
import org.maxkey.authz.oauth2.provider.TokenGranter;
import org.maxkey.authz.oauth2.provider.client.ClientCredentialsTokenGranter;
import org.maxkey.authz.oauth2.provider.code.AuthorizationCodeServices;
import org.maxkey.authz.oauth2.provider.code.AuthorizationCodeTokenGranter;
import org.maxkey.authz.oauth2.provider.code.InMemoryAuthorizationCodeServices;
import org.maxkey.authz.oauth2.provider.implicit.ImplicitTokenGranter;
import org.maxkey.authz.oauth2.provider.refresh.RefreshTokenGranter;
import org.maxkey.authz.oauth2.provider.request.DefaultOAuth2RequestFactory;
import org.maxkey.authz.oauth2.provider.token.AuthorizationServerTokenServices;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.util.Assert;

public class AbstractEndpoint
implements InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private TokenGranter tokenGranter;
    @Autowired
    @Qualifier(value="oauth20AuthorizationCodeServices")
    protected AuthorizationCodeServices authorizationCodeServices = new InMemoryAuthorizationCodeServices();
    @Autowired
    @Qualifier(value="oauth20TokenServices")
    AuthorizationServerTokenServices tokenServices;
    @Autowired
    @Qualifier(value="oauth20JdbcClientDetailsService")
    private ClientDetailsService clientDetailsService;
    @Autowired
    @Qualifier(value="oAuth2RequestFactory")
    private OAuth2RequestFactory oAuth2RequestFactory;
    @Autowired
    @Qualifier(value="oAuth2RequestFactory")
    private OAuth2RequestFactory defaultOAuth2RequestFactory;

    public void afterPropertiesSet() throws Exception {
        if (this.tokenGranter == null) {
            ArrayList<TokenGranter> tokenGranters = new ArrayList<TokenGranter>();
            tokenGranters.add(new AuthorizationCodeTokenGranter(this.tokenServices, this.authorizationCodeServices, this.clientDetailsService, this.oAuth2RequestFactory));
            tokenGranters.add(new RefreshTokenGranter(this.tokenServices, this.clientDetailsService, this.oAuth2RequestFactory));
            ImplicitTokenGranter implicit = new ImplicitTokenGranter(this.tokenServices, this.clientDetailsService, this.oAuth2RequestFactory);
            tokenGranters.add(implicit);
            tokenGranters.add(new ClientCredentialsTokenGranter(this.tokenServices, this.clientDetailsService, this.oAuth2RequestFactory));
            this.tokenGranter = new CompositeTokenGranter(tokenGranters);
        }
        Assert.state((this.tokenGranter != null ? 1 : 0) != 0, (String)"TokenGranter must be provided");
        Assert.state((this.clientDetailsService != null ? 1 : 0) != 0, (String)"ClientDetailsService must be provided");
        this.defaultOAuth2RequestFactory = new DefaultOAuth2RequestFactory(this.getClientDetailsService());
        if (this.oAuth2RequestFactory == null) {
            this.oAuth2RequestFactory = this.defaultOAuth2RequestFactory;
        }
    }

    public void setTokenGranter(TokenGranter tokenGranter) {
        this.tokenGranter = tokenGranter;
    }

    protected TokenGranter getTokenGranter() {
        return this.tokenGranter;
    }

    protected OAuth2RequestFactory getOAuth2RequestFactory() {
        return this.oAuth2RequestFactory;
    }

    protected OAuth2RequestFactory getDefaultOAuth2RequestFactory() {
        return this.defaultOAuth2RequestFactory;
    }

    public void setOAuth2RequestFactory(OAuth2RequestFactory oAuth2RequestFactory) {
        this.oAuth2RequestFactory = oAuth2RequestFactory;
    }

    protected ClientDetailsService getClientDetailsService() {
        return this.clientDetailsService;
    }

    public void setClientDetailsService(ClientDetailsService clientDetailsService) {
        this.clientDetailsService = clientDetailsService;
    }
}

