/*
 * Decompiled with CFR 0.152.
 */
package org.maxkey.authz.oauth2.provider.approval.controller;

import java.util.Set;
import org.maxkey.authz.oauth2.provider.AuthorizationRequest;
import org.maxkey.authz.oauth2.provider.ClientDetailsService;
import org.maxkey.authz.oauth2.provider.ClientRegistrationException;
import org.maxkey.authz.oauth2.provider.approval.ApprovalStoreUserApprovalHandler;
import org.maxkey.domain.apps.oauth2.provider.ClientDetails;
import org.springframework.security.core.Authentication;

public class OAuth20UserApprovalHandler
extends ApprovalStoreUserApprovalHandler {
    private boolean useApprovalStore = true;
    private ClientDetailsService clientDetailsService;

    @Override
    public void setClientDetailsService(ClientDetailsService clientDetailsService) {
        this.clientDetailsService = clientDetailsService;
        super.setClientDetailsService(clientDetailsService);
    }

    public void setUseApprovalStore(boolean useApprovalStore) {
        this.useApprovalStore = useApprovalStore;
    }

    @Override
    public AuthorizationRequest checkForPreApproval(AuthorizationRequest authorizationRequest, Authentication userAuthentication) {
        boolean approved = false;
        if (this.useApprovalStore) {
            authorizationRequest = super.checkForPreApproval(authorizationRequest, userAuthentication);
            approved = authorizationRequest.isApproved();
        } else if (this.clientDetailsService != null) {
            Set requestedScopes = authorizationRequest.getScope();
            try {
                ClientDetails client = this.clientDetailsService.loadClientByClientId(authorizationRequest.getClientId());
                for (String scope : requestedScopes) {
                    if (!client.isAutoApprove(scope) && !client.isAutoApprove("all")) continue;
                    approved = true;
                    break;
                }
            }
            catch (ClientRegistrationException clientRegistrationException) {
                // empty catch block
            }
        }
        authorizationRequest.setApproved(approved);
        return authorizationRequest;
    }
}

