/*
 * Decompiled with CFR 0.152.
 */
package org.maxkey.authz.oauth2.provider.approval.controller;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.maxkey.authn.BasicAuthentication;
import org.maxkey.authz.oauth2.provider.AuthorizationRequest;
import org.maxkey.authz.oauth2.provider.ClientDetailsService;
import org.maxkey.authz.oauth2.provider.approval.Approval;
import org.maxkey.authz.oauth2.provider.approval.ApprovalStore;
import org.maxkey.authz.oauth2.provider.approval.controller.OAuth20UserApprovalHandler;
import org.maxkey.domain.apps.oauth2.provider.ClientDetails;
import org.maxkey.web.WebContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.servlet.ModelAndView;

@Controller
@SessionAttributes(value={"authorizationRequest"})
public class OAuth20AccessConfirmationController {
    @Autowired
    @Qualifier(value="oauth20JdbcClientDetailsService")
    private ClientDetailsService clientDetailsService;
    @Autowired
    @Qualifier(value="oauth20ApprovalStore")
    private ApprovalStore approvalStore;
    @Autowired
    @Qualifier(value="oauth20UserApprovalHandler")
    OAuth20UserApprovalHandler oauth20UserApprovalHandler;

    @RequestMapping(value={"/oauth/v20/approval_confirm"})
    public ModelAndView getAccessConfirmation(@RequestParam Map<String, Object> model) throws Exception {
        model.remove("authorizationRequest");
        HashMap<String, String> modelRequest = new HashMap<String, String>();
        for (String key : model.keySet()) {
            modelRequest.put(key.toString(), model.get(key).toString());
        }
        String principal = ((BasicAuthentication)WebContext.getAuthentication().getPrincipal()).getJ_username();
        AuthorizationRequest clientAuth = (AuthorizationRequest)WebContext.getAttribute((String)"authorizationRequest");
        ClientDetails client = this.clientDetailsService.loadClientByClientId(clientAuth.getClientId());
        model.put("auth_request", clientAuth);
        model.put("client", client);
        model.put("oauth_version", "oauth 2.0");
        LinkedHashMap<String, String> scopes = new LinkedHashMap<String, String>();
        for (String scope : clientAuth.getScope()) {
            scopes.put("scope." + scope, "false");
        }
        for (Approval approval : this.approvalStore.getApprovals(principal, client.getClientId())) {
            if (!clientAuth.getScope().contains(approval.getScope())) continue;
            scopes.put("scope." + approval.getScope(), approval.getStatus() == Approval.ApprovalStatus.APPROVED ? "true" : "false");
        }
        model.put("scopes", scopes);
        ModelAndView modelAndView = new ModelAndView("authorize/oauth_access_confirmation");
        modelAndView.addObject("model", model);
        return modelAndView;
    }

    @RequestMapping(value={"/oauth/v20/error"})
    public String handleError(Map<String, Object> model) throws Exception {
        model.put("message", "There was a problem with the OAuth2 protocol");
        return "oauth_error";
    }
}

