/*
 * Decompiled with CFR 0.152.
 */
package org.maxkey.authz.oauth2.common.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.springframework.util.StringUtils;

public abstract class OAuth2Utils {
    public static final String CLIENT_ID = "client_id";
    public static final String STATE = "state";
    public static final String SCOPE = "scope";
    public static final String REDIRECT_URI = "redirect_uri";
    public static final String RESPONSE_TYPE = "response_type";
    public static final String USER_OAUTH_APPROVAL = "user_oauth_approval";
    public static final String SCOPE_PREFIX = "scope.";
    public static final String GRANT_TYPE = "grant_type";

    public static Set<String> parseParameterList(String values) {
        TreeSet<String> result = new TreeSet<String>();
        if (values != null && values.trim().length() > 0) {
            String[] tokens = values.split("[\\s+]");
            result.addAll(Arrays.asList(tokens));
        }
        return result;
    }

    public static String formatParameterList(Collection<String> value) {
        return value == null ? null : StringUtils.collectionToDelimitedString(value, (String)" ");
    }

    public static Map<String, String> extractMap(String query) {
        HashMap<String, String> map = new HashMap<String, String>();
        Properties properties = StringUtils.splitArrayElementsIntoProperties((String[])StringUtils.delimitedListToStringArray((String)query, (String)"&"), (String)"=");
        if (properties != null) {
            for (Object key : properties.keySet()) {
                map.put(key.toString(), properties.get(key).toString());
            }
        }
        return map;
    }

    public static boolean containsAll(Set<String> target, Set<String> members) {
        target = new HashSet<String>(target);
        target.retainAll(members);
        return target.size() == members.size();
    }
}

