/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.query.builder;

import org.apache.commons.lang3.StringUtils;
import org.dromara.mybatis.jpa.handler.SafeValueHandler;
import org.dromara.mybatis.jpa.query.Condition;
import org.dromara.mybatis.jpa.query.ConditionValue;
import org.dromara.mybatis.jpa.query.Operator;
import org.dromara.mybatis.jpa.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryBuilder {
    private static final Logger logger = LoggerFactory.getLogger(QueryBuilder.class);

    public static String build(Query query) {
        StringBuilder conditionString = new StringBuilder("");
        Operator lastExpression = Operator.AND;
        for (Condition condition : query.getConditions()) {
            String inValues;
            Operator expression = condition.getExpression();
            Object value = condition.getValue();
            String column = SafeValueHandler.safeColumn(condition.getColumn());
            condition.setColumn(column);
            if (expression.equals((Object)Operator.AND) || expression.equals((Object)Operator.OR)) {
                Query subQuery;
                String conditionSubString;
                lastExpression = condition.getExpression();
                if (!(value instanceof Query) || !StringUtils.isNotBlank((CharSequence)(conditionSubString = QueryBuilder.build(subQuery = (Query)value)))) continue;
                conditionString.append(QueryBuilder.appendExpression(conditionString.toString(), lastExpression));
                conditionString.append(" ( ").append(conditionSubString).append(" ) ");
                continue;
            }
            if (expression.equals((Object)Operator.CONDITION)) {
                conditionString.append(column);
                continue;
            }
            logger.trace("Expression {} column {} value class {}", new Object[]{lastExpression, column, value == null ? "" : value.getClass().getCanonicalName()});
            conditionString.append(QueryBuilder.appendExpression(conditionString.toString(), lastExpression));
            if (expression.equals((Object)Operator.LIKE) || expression.equals((Object)Operator.NOT_LIKE)) {
                conditionString.append(column).append(" ").append(expression.getOperator()).append(" ");
                conditionString.append("'%").append(SafeValueHandler.valueOf(value)).append("%'");
                continue;
            }
            if (expression.equals((Object)Operator.IGNORE_CASE)) {
                conditionString.append("UPPER(").append(column).append(") ").append(Operator.EQ.getOperator()).append(" ");
                conditionString.append("UPPER(").append(SafeValueHandler.valueOf(value)).append(")");
                continue;
            }
            if (expression.equals((Object)Operator.LIKE_LEFT)) {
                conditionString.append(column).append(" ").append(expression.getOperator()).append(" ");
                conditionString.append("'%").append(SafeValueHandler.valueOf(value)).append("'");
                continue;
            }
            if (expression.equals((Object)Operator.LIKE_RIGHT)) {
                conditionString.append(column).append(" ").append(expression.getOperator()).append(" ");
                conditionString.append("'").append(SafeValueHandler.valueOf(value)).append("%'");
                continue;
            }
            if (expression.equals((Object)Operator.EQ) || expression.equals((Object)Operator.NOT_EQ) || expression.equals((Object)Operator.GT) || expression.equals((Object)Operator.GE) || expression.equals((Object)Operator.LT) || expression.equals((Object)Operator.LE)) {
                conditionString.append(column).append(" ").append(expression.getOperator()).append(" ");
                conditionString.append(SafeValueHandler.valueOfType(value));
                continue;
            }
            if (expression.equals((Object)Operator.BETWEEN) || expression.equals((Object)Operator.NOT_BETWEEN)) {
                conditionString.append(" ( ").append(column).append(" ").append(expression.getOperator()).append(" ");
                conditionString.append(SafeValueHandler.valueOfType(value));
                conditionString.append(" and ");
                conditionString.append(SafeValueHandler.valueOfType(condition.getValue2())).append(" ) ");
                continue;
            }
            if (expression.equals((Object)Operator.IS_NULL) || expression.equals((Object)Operator.IS_NOT_NULL)) {
                conditionString.append(column).append(" ").append(expression.getOperator());
                continue;
            }
            if (!expression.equals((Object)Operator.IN) && !expression.equals((Object)Operator.NOT_IN) || !StringUtils.isNotBlank((CharSequence)(inValues = ConditionValue.getCollectionValues(value)))) continue;
            conditionString.append(column).append(" ").append(expression.getOperator());
            conditionString.append(" ( ").append(inValues).append(" ) ");
        }
        logger.trace("conditionString {}", (Object)conditionString);
        return conditionString.toString();
    }

    public static String appendExpression(String conditionString, Operator lastExpression) {
        return StringUtils.isBlank((CharSequence)conditionString) ? "" : " " + lastExpression + " ";
    }

    public static String buildGroupBy(Query query) {
        StringBuilder groupBy = new StringBuilder();
        for (Condition condition : query.getGroupBy()) {
            if (!groupBy.isEmpty()) {
                groupBy.append(" , ");
            }
            groupBy.append(SafeValueHandler.safeColumn(condition.getColumn()));
        }
        return groupBy.toString();
    }

    public static String buildOrderBy(Query query) {
        StringBuilder orderBy = new StringBuilder();
        for (Condition condition : query.getOrderBy()) {
            if (!orderBy.isEmpty()) {
                orderBy.append(" , ");
            }
            orderBy.append(SafeValueHandler.safeColumn(condition.getColumn()));
            orderBy.append(" ");
            orderBy.append(SafeValueHandler.valueOf(condition.getValue()));
        }
        return orderBy.toString();
    }
}

