/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.provider;

import java.util.ArrayList;
import java.util.Map;
import org.apache.ibatis.jdbc.SQL;
import org.dromara.mybatis.jpa.entity.JpaEntity;
import org.dromara.mybatis.jpa.metadata.FieldColumnMapper;
import org.dromara.mybatis.jpa.metadata.MapperMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteProvider<T extends JpaEntity> {
    private static final Logger logger = LoggerFactory.getLogger(DeleteProvider.class);

    public String remove(Map<String, Object> parametersMap) {
        Class entityClass = (Class)parametersMap.get("entityClass");
        MapperMetadata.buildColumnList(entityClass);
        String tableName = MapperMetadata.getTableName(entityClass);
        if (MapperMetadata.sqlsMap.containsKey(String.valueOf(tableName) + "_REMOVE_SQL")) {
            return (String)MapperMetadata.sqlsMap.get(String.valueOf(tableName) + "_REMOVE_SQL");
        }
        String idValue = (String)parametersMap.get("id");
        String partitionKeyValue = (String)parametersMap.get("partitionKey");
        FieldColumnMapper partitionKeyColumnMapper = MapperMetadata.getPartitionKey(entityClass.getSimpleName());
        FieldColumnMapper idFieldColumnMapper = MapperMetadata.getIdColumn(entityClass.getSimpleName());
        SQL sql = (SQL)new SQL().DELETE_FROM(tableName);
        if (partitionKeyColumnMapper != null && partitionKeyValue != null) {
            sql.WHERE(" %s = #{%s} and %s = '%s' ".formatted(partitionKeyColumnMapper.getColumnName(), partitionKeyValue, idFieldColumnMapper.getColumnName(), idValue));
        } else {
            sql.WHERE("%s = '%s'".formatted(idFieldColumnMapper.getColumnName(), idValue));
        }
        String deleteSql = sql.toString();
        MapperMetadata.sqlsMap.put(String.valueOf(tableName) + "_REMOVE_SQL", deleteSql);
        logger.trace("Delete SQL \n{}", (Object)deleteSql);
        return deleteSql;
    }

    public String batchDelete(Map<String, Object> parametersMap) {
        Class entityClass = (Class)parametersMap.get("entityClass");
        MapperMetadata.buildColumnList(entityClass);
        String tableName = MapperMetadata.getTableName(entityClass);
        ArrayList idValues = (ArrayList)parametersMap.get("idList");
        StringBuffer keyValue = new StringBuffer();
        for (String value : idValues) {
            if (value.trim().length() <= 0) continue;
            keyValue.append(",'").append(value).append("'");
            logger.trace("logic delete by id {}", (Object)value);
        }
        String keyValues = keyValue.substring(1).replaceAll(";", "");
        String partitionKeyValue = (String)parametersMap.get("partitionKey");
        FieldColumnMapper partitionKeyColumnMapper = MapperMetadata.getPartitionKey(entityClass.getSimpleName());
        FieldColumnMapper idFieldColumnMapper = MapperMetadata.getIdColumn(entityClass.getSimpleName());
        SQL sql = (SQL)new SQL().DELETE_FROM(tableName);
        if (partitionKeyColumnMapper != null && partitionKeyValue != null) {
            sql.WHERE("%s = #{%s} and %s  in ( %s )".formatted(partitionKeyColumnMapper.getColumnName(), partitionKeyValue, idFieldColumnMapper.getColumnName(), idFieldColumnMapper.getFieldName()));
        } else {
            sql.WHERE(" %s in ( %s )".formatted(idFieldColumnMapper.getColumnName(), keyValues));
        }
        String deleteSql = sql.toString();
        MapperMetadata.sqlsMap.put(String.valueOf(tableName) + "_BATCHDELETE_SQL", deleteSql);
        logger.trace("Delete SQL \n{}", (Object)deleteSql);
        return deleteSql;
    }
}

