/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.jdbc;

import com.kingbase8.core.Utils;
import com.kingbase8.util.GT;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import java.sql.SQLException;
import java.sql.Savepoint;

public class PSQLSavepoint
implements Savepoint,
Cloneable {
    private boolean isValid = true;
    private final boolean isNamed;
    private int id;
    private String name;

    public PSQLSavepoint(int id) {
        this.isNamed = false;
        this.id = id;
    }

    public PSQLSavepoint(String name) {
        this.isNamed = true;
        this.name = name;
    }

    @Override
    public int getSavepointId() throws SQLException {
        if (!this.isValid) {
            throw new KSQLException(GT.tr("Cannot reference a savepoint after it has been released.", new Object[0]), KSQLState.INVALID_SAVEPOINT_SPECIFICATION);
        }
        if (this.isNamed) {
            throw new KSQLException(GT.tr("Cannot retrieve the id of a named savepoint.", new Object[0]), KSQLState.WRONG_OBJECT_TYPE);
        }
        return this.id;
    }

    @Override
    public String getSavepointName() throws SQLException {
        if (!this.isValid) {
            throw new KSQLException(GT.tr("Cannot reference a savepoint after it has been released.", new Object[0]), KSQLState.INVALID_SAVEPOINT_SPECIFICATION);
        }
        if (!this.isNamed) {
            throw new KSQLException(GT.tr("Cannot retrieve the name of an unnamed savepoint.", new Object[0]), KSQLState.WRONG_OBJECT_TYPE);
        }
        return this.name;
    }

    public void invalidate() {
        this.isValid = false;
    }

    public String getPGName() throws SQLException {
        if (!this.isValid) {
            throw new KSQLException(GT.tr("Cannot reference a savepoint after it has been released.", new Object[0]), KSQLState.INVALID_SAVEPOINT_SPECIFICATION);
        }
        if (this.isNamed) {
            return Utils.escapeIdentifier(null, this.name).toString();
        }
        return "JDBC_SAVEPOINT_" + this.id;
    }

    public PSQLSavepoint clone() {
        PSQLSavepoint savepoint = null;
        try {
            savepoint = (PSQLSavepoint)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return savepoint;
    }
}

