/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.gss;

import com.kingbase8.core.KBStream;
import com.kingbase8.gss.GSSCallbackHandler;
import com.kingbase8.gss.GssAction;
import com.kingbase8.util.GT;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.LOGGER;
import java.io.IOException;
import java.security.AccessController;
import java.sql.SQLException;
import java.util.Set;
import java.util.logging.Level;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import org.ietf.jgss.GSSCredential;

public class MakeGSS {
    public static void authenticate(KBStream pgStream, String host, String user, String password, String jaasApplicationName, String kerberosServerName, boolean useSpnego, boolean jaasLogin, boolean logServerErrorDetail) throws IOException, SQLException {
        Exception result;
        LOGGER.log(Level.FINEST, " <=BE AuthenticationReqGSS", new Object[0]);
        if (jaasApplicationName == null) {
            jaasApplicationName = "kbjdbc";
        }
        if (kerberosServerName == null) {
            kerberosServerName = "postgres";
        }
        try {
            Set<GSSCredential> gssCreds;
            boolean performAuthentication = jaasLogin;
            GSSCredential gssCredential = null;
            Subject sub = Subject.getSubject(AccessController.getContext());
            if (sub != null && (gssCreds = sub.getPrivateCredentials(GSSCredential.class)) != null && !gssCreds.isEmpty()) {
                gssCredential = gssCreds.iterator().next();
                performAuthentication = false;
            }
            if (performAuthentication) {
                LoginContext lc = new LoginContext(jaasApplicationName, new GSSCallbackHandler(user, password));
                lc.login();
                sub = lc.getSubject();
            }
            GssAction action = new GssAction(pgStream, gssCredential, host, user, kerberosServerName, useSpnego, logServerErrorDetail);
            result = Subject.doAs(sub, action);
        }
        catch (Exception e) {
            throw new KSQLException(GT.tr("GSS Authentication failed", new Object[0]), KSQLState.CONNECTION_FAILURE, (Throwable)e);
        }
        if (result instanceof IOException) {
            throw (IOException)result;
        }
        if (result instanceof SQLException) {
            throw (SQLException)result;
        }
        if (result != null) {
            throw new KSQLException(GT.tr("GSS Authentication failed", new Object[0]), KSQLState.CONNECTION_FAILURE, (Throwable)result);
        }
    }
}

