/*
 * Decompiled with CFR 0.152.
 */
package com.highgo.jdbc.replication.fluent;

import com.highgo.jdbc.core.BaseConnection;
import com.highgo.jdbc.core.ReplicationProtocol;
import com.highgo.jdbc.replication.PGReplicationStream;
import com.highgo.jdbc.replication.fluent.ChainedStreamBuilder;
import com.highgo.jdbc.replication.fluent.logical.ChainedLogicalStreamBuilder;
import com.highgo.jdbc.replication.fluent.logical.LogicalReplicationOptions;
import com.highgo.jdbc.replication.fluent.logical.LogicalStreamBuilder;
import com.highgo.jdbc.replication.fluent.logical.StartLogicalReplicationCallback;
import com.highgo.jdbc.replication.fluent.physical.ChainedPhysicalStreamBuilder;
import com.highgo.jdbc.replication.fluent.physical.PhysicalReplicationOptions;
import com.highgo.jdbc.replication.fluent.physical.PhysicalStreamBuilder;
import com.highgo.jdbc.replication.fluent.physical.StartPhysicalReplicationCallback;
import java.sql.SQLException;

public class ReplicationStreamBuilder
implements ChainedStreamBuilder {
    private final BaseConnection baseConnection;

    public ReplicationStreamBuilder(BaseConnection connection) {
        this.baseConnection = connection;
    }

    @Override
    public ChainedLogicalStreamBuilder logical() {
        return new LogicalStreamBuilder(new StartLogicalReplicationCallback(){

            @Override
            public PGReplicationStream start(LogicalReplicationOptions options) throws SQLException {
                ReplicationProtocol protocol = ReplicationStreamBuilder.this.baseConnection.getReplicationProtocol();
                return protocol.startLogical(options);
            }
        });
    }

    @Override
    public ChainedPhysicalStreamBuilder physical() {
        return new PhysicalStreamBuilder(new StartPhysicalReplicationCallback(){

            @Override
            public PGReplicationStream start(PhysicalReplicationOptions options) throws SQLException {
                ReplicationProtocol protocol = ReplicationStreamBuilder.this.baseConnection.getReplicationProtocol();
                return protocol.startPhysical(options);
            }
        });
    }
}

