/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.jose.jwk;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.Use;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;

public class ECKeyMaker {
    public static ECKey make(ECKey.Curve crv, Use keyUse, Algorithm keyAlg, String kid) {
        try {
            ECParameterSpec ecSpec = crv.toECParameterSpec();
            KeyPairGenerator generator = KeyPairGenerator.getInstance("EC");
            generator.initialize(ecSpec);
            KeyPair kp = generator.generateKeyPair();
            ECPublicKey pub = (ECPublicKey)kp.getPublic();
            ECPrivateKey priv = (ECPrivateKey)kp.getPrivate();
            ECKey key = new ECKey(crv, pub, priv, keyUse, keyAlg, kid);
            return key;
        }
        catch (InvalidAlgorithmParameterException e) {
            e.printStackTrace();
            return null;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }
}

