/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.internal.toplink.remoting;

import com.taobao.api.internal.toplink.Text;
import com.taobao.api.internal.toplink.remoting.MethodReturn;
import com.taobao.api.internal.toplink.remoting.RemotingCallback;
import com.taobao.api.internal.toplink.remoting.RemotingException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class SynchronizedRemotingCallback
extends RemotingCallback {
    private CountDownLatch latch = new CountDownLatch(1);
    private MethodReturn methodReturn;
    private boolean sucess;
    private Throwable failure;

    public boolean isSucess() {
        return this.sucess;
    }

    public Throwable getFailure() {
        return this.failure;
    }

    public MethodReturn getMethodReturn() {
        return this.methodReturn;
    }

    public void onMethodReturn(MethodReturn methodReturn) {
        this.sucess = true;
        this.methodReturn = methodReturn;
        this.nofityCall();
    }

    public void onException(Throwable exception) {
        this.sucess = false;
        this.failure = exception;
        this.nofityCall();
    }

    public void waitReturn(int timeout) throws RemotingException {
        try {
            if (timeout > 0) {
                if (!this.latch.await(timeout, TimeUnit.MILLISECONDS)) {
                    throw new RemotingException(Text.RPC_EXECUTE_TIMEOUT);
                }
            } else {
                this.latch.await();
            }
        }
        catch (InterruptedException e) {
            throw new RemotingException(Text.RPC_WAIT_INTERRUPTED, e);
        }
    }

    private void nofityCall() {
        this.latch.countDown();
    }
}

