/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.dromara.mybatis.jpa.functions.IGetter;
import org.dromara.mybatis.jpa.query.Condition;
import org.dromara.mybatis.jpa.query.Operator;
import org.dromara.mybatis.jpa.util.LambdaUtil;

public class LambdaQuery<T> {
    List<Condition> conditions = new ArrayList<Condition>();
    List<Condition> groupBy;
    List<Condition> orderBy;
    boolean softDelete = true;

    public void joint() {
        Operator lastJoint;
        if (CollectionUtils.isNotEmpty(this.conditions) && !(lastJoint = this.conditions.get(this.conditions.size() - 1).getExpression()).equals((Object)Operator.AND) && !lastJoint.equals((Object)Operator.OR)) {
            this.and();
        }
    }

    public LambdaQuery<T> and() {
        this.conditions.add(new Condition(Operator.AND, "", null));
        return this;
    }

    public LambdaQuery<T> or() {
        this.conditions.add(new Condition(Operator.OR, "", null));
        return this;
    }

    public LambdaQuery<T> and(LambdaQuery<T> subQuery) {
        this.conditions.add(new Condition(Operator.AND, "", subQuery));
        return this;
    }

    public LambdaQuery<T> or(LambdaQuery<T> subQuery) {
        this.conditions.add(new Condition(Operator.OR, "", subQuery));
        return this;
    }

    public LambdaQuery<T> eq(IGetter<T> getter, Object value) {
        this.conditions.add(new Condition(Operator.EQ, this.getColumnName(getter), value));
        return this;
    }

    public LambdaQuery<T> eq(boolean expression, IGetter<T> getter, Object value) {
        if (expression) {
            this.eq(getter, value);
        }
        return this;
    }

    public LambdaQuery<T> notEq(IGetter<T> getter, Object value) {
        this.conditions.add(new Condition(Operator.NOT_EQ, this.getColumnName(getter), value));
        return this;
    }

    public LambdaQuery<T> notEq(boolean expression, IGetter<T> getter, Object value) {
        if (expression) {
            this.notEq(getter, value);
        }
        return this;
    }

    public LambdaQuery<T> gt(IGetter<T> getter, Object value) {
        this.conditions.add(new Condition(Operator.GT, this.getColumnName(getter), value));
        return this;
    }

    public LambdaQuery<T> gt(boolean expression, IGetter<T> getter, Object value) {
        if (expression) {
            this.gt(getter, value);
        }
        return this;
    }

    public LambdaQuery<T> ge(IGetter<T> getter, Object value) {
        this.conditions.add(new Condition(Operator.GE, this.getColumnName(getter), value));
        return this;
    }

    public LambdaQuery<T> ge(boolean expression, IGetter<T> getter, Object value) {
        if (expression) {
            this.ge(getter, value);
        }
        return this;
    }

    public LambdaQuery<T> lt(IGetter<T> getter, Object value) {
        this.conditions.add(new Condition(Operator.LT, this.getColumnName(getter), value));
        return this;
    }

    public LambdaQuery<T> lt(boolean expression, IGetter<T> getter, Object value) {
        if (expression) {
            this.lt(getter, value);
        }
        return this;
    }

    public LambdaQuery<T> le(IGetter<T> getter, Object value) {
        this.conditions.add(new Condition(Operator.LE, this.getColumnName(getter), value));
        return this;
    }

    public LambdaQuery<T> le(boolean expression, IGetter<T> getter, Object value) {
        if (expression) {
            this.le(getter, value);
        }
        return this;
    }

    public LambdaQuery<T> like(IGetter<T> getter, String value) {
        this.conditions.add(new Condition(Operator.LIKE, this.getColumnName(getter), value));
        return this;
    }

    public LambdaQuery<T> like(boolean expression, IGetter<T> getter, String value) {
        if (expression) {
            this.like(getter, value);
        }
        return this;
    }

    public LambdaQuery<T> likeLeft(IGetter<T> getter, String value) {
        this.conditions.add(new Condition(Operator.LIKE_LEFT, this.getColumnName(getter), value));
        return this;
    }

    public LambdaQuery<T> likeLeft(boolean expression, IGetter<T> getter, String value) {
        if (expression) {
            this.likeLeft(getter, value);
        }
        return this;
    }

    public LambdaQuery<T> likeRight(IGetter<T> getter, String value) {
        this.conditions.add(new Condition(Operator.LIKE_RIGHT, this.getColumnName(getter), value));
        return this;
    }

    public LambdaQuery<T> likeRight(boolean expression, IGetter<T> getter, String value) {
        if (expression) {
            this.likeRight(getter, value);
        }
        return this;
    }

    public LambdaQuery<T> in(IGetter<T> getter, Collection<?> value) {
        this.conditions.add(new Condition(Operator.IN, this.getColumnName(getter), value));
        return this;
    }

    public LambdaQuery<T> in(boolean expression, IGetter<T> getter, Collection<?> value) {
        if (expression) {
            this.in(getter, value);
        }
        return this;
    }

    public LambdaQuery<T> in(IGetter<T> getter, Object[] value) {
        this.conditions.add(new Condition(Operator.IN, this.getColumnName(getter), value));
        return this;
    }

    public LambdaQuery<T> in(boolean expression, IGetter<T> getter, Object[] value) {
        if (expression) {
            this.in(getter, value);
        }
        return this;
    }

    public LambdaQuery<T> notIn(IGetter<T> getter, Collection<?> value) {
        this.conditions.add(new Condition(Operator.NOT_IN, this.getColumnName(getter), value));
        return this;
    }

    public LambdaQuery<T> notIn(boolean expression, IGetter<T> getter, Collection<?> value) {
        if (expression) {
            this.notIn(getter, value);
        }
        return this;
    }

    public LambdaQuery<T> notIn(IGetter<T> getter, Object[] value) {
        this.conditions.add(new Condition(Operator.NOT_IN, this.getColumnName(getter), value));
        return this;
    }

    public LambdaQuery<T> notIn(boolean expression, IGetter<T> getter, Object[] value) {
        if (expression) {
            this.notIn(getter, value);
        }
        return this;
    }

    public LambdaQuery<T> between(IGetter<T> getter, Object startValue, Object endValue) {
        this.conditions.add(new Condition(Operator.BETWEEN, this.getColumnName(getter), startValue, endValue));
        return this;
    }

    public LambdaQuery<T> between(boolean expression, IGetter<T> getter, Object startValue, Object endValue) {
        if (expression) {
            this.between(getter, startValue, endValue);
        }
        return this;
    }

    public LambdaQuery<T> between(IGetter<T> getter, Object[] values) {
        this.conditions.add(new Condition(Operator.BETWEEN, this.getColumnName(getter), values[0], values[1]));
        return this;
    }

    public LambdaQuery<T> between(boolean expression, IGetter<T> getter, Object[] values) {
        if (expression) {
            this.between(getter, values);
        }
        return this;
    }

    public LambdaQuery<T> between(IGetter<T> getter, List<?> values) {
        this.conditions.add(new Condition(Operator.BETWEEN, this.getColumnName(getter), values.get(0), values.get(1)));
        return this;
    }

    public LambdaQuery<T> between(boolean expression, IGetter<T> getter, List<?> values) {
        if (expression) {
            this.between(getter, values);
        }
        return this;
    }

    public LambdaQuery<T> notNull(IGetter<T> getter) {
        this.conditions.add(new Condition(Operator.IS_NOT_NULL, this.getColumnName(getter), " IS NOT NULL"));
        return this;
    }

    public LambdaQuery<T> notNull(boolean expression, IGetter<T> getter) {
        if (expression) {
            this.notNull(getter);
        }
        return this;
    }

    public LambdaQuery<T> isNull(IGetter<T> getter) {
        this.conditions.add(new Condition(Operator.IS_NULL, this.getColumnName(getter), " IS NULL"));
        return this;
    }

    public LambdaQuery<T> isNull(boolean expression, IGetter<T> getter) {
        if (expression) {
            this.isNull(getter);
        }
        return this;
    }

    public LambdaQuery<T> condition(String conditionSql) {
        this.joint();
        this.conditions.add(new Condition(Operator.CONDITION, conditionSql, null));
        return this;
    }

    public LambdaQuery<T> groupBy(IGetter<T> getter) {
        if (CollectionUtils.isEmpty(this.groupBy)) {
            this.groupBy = new ArrayList<Condition>();
        }
        this.groupBy.add(new Condition(Operator.GROUP, this.getColumnName(getter), ""));
        return this;
    }

    public LambdaQuery<T> orderBy(IGetter<T> getter, String orderType) {
        if (CollectionUtils.isEmpty(this.orderBy)) {
            this.orderBy = new ArrayList<Condition>();
        }
        this.orderBy.add(new Condition(Operator.ORDER, this.getColumnName(getter), orderType));
        return this;
    }

    public List<Condition> getGroupBy() {
        return this.groupBy;
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public List<Condition> getOrderBy() {
        return this.orderBy;
    }

    public boolean isSoftDelete() {
        return this.softDelete;
    }

    public void setSoftDelete(boolean softDelete) {
        this.softDelete = softDelete;
    }

    public String getColumnName(IGetter<T> getter) {
        return LambdaUtil.getColumnName(getter);
    }

    public String toString() {
        return "Query [conditions=" + String.valueOf(this.conditions) + ", orderBy=" + String.valueOf(this.orderBy) + "]";
    }
}

