/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.provider;

import java.util.List;
import org.apache.ibatis.jdbc.SQL;
import org.dromara.mybatis.jpa.entity.JpaEntity;
import org.dromara.mybatis.jpa.metadata.FieldColumnMapper;
import org.dromara.mybatis.jpa.metadata.FieldMetadata;
import org.dromara.mybatis.jpa.metadata.TableMetadata;
import org.dromara.mybatis.jpa.provider.DateConverter;
import org.dromara.mybatis.jpa.query.LambdaQuery;
import org.dromara.mybatis.jpa.query.LambdaQueryBuilder;
import org.dromara.mybatis.jpa.query.Query;
import org.dromara.mybatis.jpa.query.QueryBuilder;
import org.dromara.mybatis.jpa.update.LambdaUpdateBuilder;
import org.dromara.mybatis.jpa.update.LambdaUpdateWrapper;
import org.dromara.mybatis.jpa.update.UpdateBuilder;
import org.dromara.mybatis.jpa.update.UpdateWrapper;
import org.dromara.mybatis.jpa.util.BeanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateProvider<T extends JpaEntity> {
    static final Logger logger = LoggerFactory.getLogger(UpdateProvider.class);

    public String update(T entity) {
        List<FieldColumnMapper> listFields = FieldMetadata.buildColumnMapper(entity.getClass());
        SQL sql = (SQL)new SQL().UPDATE(TableMetadata.getTableName(entity.getClass()));
        FieldColumnMapper partitionKey = null;
        FieldColumnMapper idFieldColumnMapper = null;
        for (FieldColumnMapper fieldColumnMapper : listFields) {
            String columnName = fieldColumnMapper.getColumnName();
            String fieldName = fieldColumnMapper.getFieldName();
            String fieldType = fieldColumnMapper.getFieldType();
            Object fieldValue = BeanUtil.getValue(entity, fieldName);
            boolean isFieldValueNull = BeanUtil.isFieldBlank(fieldValue);
            if (fieldColumnMapper.isIdColumn()) {
                idFieldColumnMapper = fieldColumnMapper;
                continue;
            }
            if (fieldColumnMapper.getPartitionKey() != null) {
                partitionKey = fieldColumnMapper;
                continue;
            }
            if (fieldColumnMapper.isLogicDelete()) continue;
            if (isFieldValueNull && !fieldColumnMapper.isGenerated()) {
                if (!logger.isTraceEnabled()) continue;
                logger.trace("Field {} , Type {} , Value is null , Skiped ", (Object)String.format("%-30s", fieldName), (Object)String.format("%-30s", fieldType));
                continue;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("Field {} , Type {} , Value {}", new Object[]{String.format("%-30s", fieldName), String.format("%-30s", fieldType), fieldValue});
            }
            if (!fieldColumnMapper.getColumnAnnotation().updatable()) continue;
            if (fieldColumnMapper.isGenerated() && fieldColumnMapper.getTemporalAnnotation() != null) {
                sql.SET(" %s =  '%s' ".formatted(columnName, DateConverter.convert(entity, fieldColumnMapper, true)));
                continue;
            }
            sql.SET(" %s = #{%s} ".formatted(columnName, fieldName));
        }
        if (idFieldColumnMapper != null) {
            if (partitionKey != null) {
                sql.WHERE("%s = #{%s}\nand %s = #{%s}\n".formatted(partitionKey.getColumnName(), partitionKey.getFieldName(), idFieldColumnMapper.getColumnName(), idFieldColumnMapper.getFieldName()));
            } else {
                sql.WHERE("%s = #{%s}".formatted(idFieldColumnMapper.getColumnName(), idFieldColumnMapper.getFieldName()));
            }
            logger.trace("Update SQL : \n{}", (Object)sql);
            return sql.toString();
        }
        return "";
    }

    public String updateByQuery(Class<?> entityClass, String setSql, Query query) {
        logger.trace("update By Query \n{}", (Object)query);
        FieldMetadata.buildColumnMapper(entityClass);
        SQL sql = (SQL)((SQL)((SQL)new SQL().UPDATE(TableMetadata.getTableName(entityClass))).SET(setSql)).WHERE(QueryBuilder.build(query));
        logger.trace("update By Query  SQL \n{}", (Object)sql);
        return sql.toString();
    }

    public String updateByLambdaQuery(Class<?> entityClass, String setSql, LambdaQuery<T> lambdaQuery) {
        logger.trace("update By LambdaQuery \n{}", lambdaQuery);
        FieldMetadata.buildColumnMapper(entityClass);
        SQL sql = (SQL)((SQL)((SQL)new SQL().UPDATE(TableMetadata.getTableName(entityClass))).SET(setSql)).WHERE(LambdaQueryBuilder.build(lambdaQuery));
        logger.trace("update By LambdaQuery  SQL \n{}", (Object)sql);
        return sql.toString();
    }

    public String updateByUpdateWrapper(Class<?> entityClass, UpdateWrapper updateWrapper) {
        logger.trace("update By UpdateWrapper \n{}", (Object)updateWrapper);
        FieldMetadata.buildColumnMapper(entityClass);
        SQL sql = (SQL)((SQL)((SQL)new SQL().UPDATE(TableMetadata.getTableName(entityClass))).SET(UpdateBuilder.buildSetSql(updateWrapper))).WHERE(QueryBuilder.build(updateWrapper));
        logger.trace("update By UpdateWrapper  SQL \n{}", (Object)sql);
        return sql.toString();
    }

    public String updateByLambdaUpdateWrapper(Class<?> entityClass, LambdaUpdateWrapper<T> lambdaUpdateWrapper) {
        logger.trace("update By LambdaUpdateWrapper \n{}", lambdaUpdateWrapper);
        FieldMetadata.buildColumnMapper(entityClass);
        SQL sql = (SQL)((SQL)((SQL)new SQL().UPDATE(TableMetadata.getTableName(entityClass))).SET(LambdaUpdateBuilder.buildSetSql(lambdaUpdateWrapper))).WHERE(LambdaQueryBuilder.build(lambdaUpdateWrapper));
        logger.trace("update By LambdaUpdateWrapper  SQL \n{}", (Object)sql);
        return sql.toString();
    }
}

