/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.provider;

import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.jdbc.SQL;
import org.dromara.mybatis.jpa.entity.JpaEntity;
import org.dromara.mybatis.jpa.handler.SafeValueHandler;
import org.dromara.mybatis.jpa.metadata.FieldColumnMapper;
import org.dromara.mybatis.jpa.metadata.FieldMetadata;
import org.dromara.mybatis.jpa.metadata.TableMetadata;
import org.dromara.mybatis.jpa.query.LambdaQuery;
import org.dromara.mybatis.jpa.query.LambdaQueryBuilder;
import org.dromara.mybatis.jpa.query.Query;
import org.dromara.mybatis.jpa.query.QueryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoftDeleteProvider<T extends JpaEntity> {
    static final Logger logger = LoggerFactory.getLogger(SoftDeleteProvider.class);

    public String softDelete(Map<String, Object> parametersMap) {
        Class entityClass = (Class)parametersMap.get("entityClass");
        FieldMetadata.buildColumnMapper(entityClass);
        ArrayList idValues = (ArrayList)parametersMap.get("idList");
        StringBuffer keyValue = new StringBuffer();
        for (String value : idValues) {
            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
            keyValue.append(",'").append(SafeValueHandler.valueOf(value)).append("'");
            logger.trace("softDelete by id {}", (Object)value);
        }
        String keyValues = keyValue.substring(1).replace(";", "");
        FieldColumnMapper logicColumnMapper = FieldMetadata.getLogicColumn(entityClass);
        String partitionKeyValue = (String)parametersMap.get("partitionKey");
        FieldColumnMapper partitionKeyColumnMapper = FieldMetadata.getPartitionKey(entityClass);
        FieldColumnMapper idFieldColumnMapper = FieldMetadata.getIdColumn(entityClass);
        SQL sql = (SQL)((SQL)new SQL().UPDATE(TableMetadata.getTableName(entityClass))).SET(" %s = '%s' ".formatted(logicColumnMapper.getColumnName(), logicColumnMapper.getSoftDelete().delete()));
        if (partitionKeyColumnMapper != null && partitionKeyValue != null) {
            sql.WHERE("%s = #{%s} and %s  in ( %s )".formatted(partitionKeyColumnMapper.getColumnName(), partitionKeyValue, idFieldColumnMapper.getColumnName(), idFieldColumnMapper.getFieldName()));
        } else {
            sql.WHERE(" %s in ( %s )".formatted(idFieldColumnMapper.getColumnName(), keyValues));
        }
        String deleteSql = sql.toString();
        logger.trace("softDelete SQL \n{}", (Object)deleteSql);
        return deleteSql;
    }

    public String softDeleteByQuery(Class<?> entityClass, Query query) {
        logger.trace("softDelete By Query \n{}", (Object)query);
        FieldMetadata.buildColumnMapper(entityClass);
        FieldColumnMapper logicColumnMapper = FieldMetadata.getLogicColumn(entityClass);
        SQL sql = (SQL)((SQL)((SQL)new SQL().UPDATE(TableMetadata.getTableName(entityClass))).SET(" %s = '%s' ".formatted(logicColumnMapper.getColumnName(), logicColumnMapper.getSoftDelete().delete()))).WHERE(QueryBuilder.build(query));
        logger.trace("softDelete By Query  SQL \n{}", (Object)sql);
        return sql.toString();
    }

    public String softDeleteByLambdaQuery(Class<?> entityClass, LambdaQuery<T> lambdaQuery) {
        logger.trace("softDelete By LambdaQuery \n{}", lambdaQuery);
        FieldMetadata.buildColumnMapper(entityClass);
        FieldColumnMapper logicColumnMapper = FieldMetadata.getLogicColumn(entityClass);
        SQL sql = (SQL)((SQL)((SQL)new SQL().UPDATE(TableMetadata.getTableName(entityClass))).SET(" %s = '%s' ".formatted(logicColumnMapper.getColumnName(), logicColumnMapper.getSoftDelete().delete()))).WHERE(LambdaQueryBuilder.build(lambdaQuery));
        logger.trace("softDelete By LambdaQuery  SQL \n{}", (Object)sql);
        return sql.toString();
    }
}

