/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.provider;

import java.util.Map;
import org.apache.ibatis.jdbc.SQL;
import org.dromara.mybatis.jpa.entity.JpaEntity;
import org.dromara.mybatis.jpa.metadata.FieldColumnMapper;
import org.dromara.mybatis.jpa.metadata.FieldMetadata;
import org.dromara.mybatis.jpa.metadata.TableMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetProvider<T extends JpaEntity> {
    static final Logger logger = LoggerFactory.getLogger(GetProvider.class);

    public String get(Map<String, Object> parametersMap) {
        FieldColumnMapper logicColumnMapper;
        Class entityClass = (Class)parametersMap.get("entityClass");
        FieldMetadata.buildColumnMapper(entityClass);
        String partitionKeyValue = (String)parametersMap.get("partitionKey");
        FieldColumnMapper partitionKeyColumnMapper = FieldMetadata.getPartitionKey(entityClass);
        FieldColumnMapper idFieldColumnMapper = FieldMetadata.getIdColumn(entityClass);
        SQL sql = TableMetadata.buildSelect(entityClass);
        sql.WHERE(" %s = #{%s}".formatted(idFieldColumnMapper.getColumnName(), idFieldColumnMapper.getFieldName()));
        if (partitionKeyColumnMapper != null && partitionKeyValue != null) {
            sql.WHERE(" %s = #{%s} ".formatted(partitionKeyColumnMapper.getColumnName(), partitionKeyValue));
        }
        if ((logicColumnMapper = FieldMetadata.getLogicColumn(entityClass)) != null && logicColumnMapper.isLogicDelete()) {
            sql.WHERE(" %s = '%s'".formatted(logicColumnMapper.getColumnName(), logicColumnMapper.getSoftDelete().value()));
        }
        String getSql = sql.toString();
        logger.trace("Get SQL \n{}", (Object)getSql);
        return getSql;
    }
}

