/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.provider;

import java.util.ArrayList;
import java.util.Map;
import org.apache.ibatis.jdbc.SQL;
import org.dromara.mybatis.jpa.entity.JpaEntity;
import org.dromara.mybatis.jpa.handler.SafeValueHandler;
import org.dromara.mybatis.jpa.metadata.FieldColumnMapper;
import org.dromara.mybatis.jpa.metadata.FieldMetadata;
import org.dromara.mybatis.jpa.metadata.TableMetadata;
import org.dromara.mybatis.jpa.query.LambdaQuery;
import org.dromara.mybatis.jpa.query.LambdaQueryBuilder;
import org.dromara.mybatis.jpa.query.Query;
import org.dromara.mybatis.jpa.query.QueryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteProvider<T extends JpaEntity> {
    static final Logger logger = LoggerFactory.getLogger(DeleteProvider.class);

    public String deleteById(Map<String, Object> parametersMap) {
        Class entityClass = (Class)parametersMap.get("entityClass");
        FieldMetadata.buildColumnMapper(entityClass);
        String idValue = (String)parametersMap.get("id");
        String partitionKeyValue = (String)parametersMap.get("partitionKey");
        FieldColumnMapper partitionKeyColumnMapper = FieldMetadata.getPartitionKey(entityClass);
        FieldColumnMapper idFieldColumnMapper = FieldMetadata.getIdColumn(entityClass);
        SQL sql = (SQL)new SQL().DELETE_FROM(TableMetadata.getTableName(entityClass));
        if (partitionKeyColumnMapper != null && partitionKeyValue != null) {
            sql.WHERE(" %s = #{%s} and %s = '%s' ".formatted(partitionKeyColumnMapper.getColumnName(), partitionKeyValue, idFieldColumnMapper.getColumnName(), SafeValueHandler.valueOf(idValue)));
        } else {
            sql.WHERE("%s = '%s'".formatted(idFieldColumnMapper.getColumnName(), SafeValueHandler.valueOf(idValue)));
        }
        String deleteSql = sql.toString();
        logger.trace("Delete SQL \n{}", (Object)deleteSql);
        return deleteSql;
    }

    public String batchDelete(Map<String, Object> parametersMap) {
        Class entityClass = (Class)parametersMap.get("entityClass");
        FieldMetadata.buildColumnMapper(entityClass);
        ArrayList idValues = (ArrayList)parametersMap.get("idList");
        StringBuffer keyValue = new StringBuffer();
        for (String value : idValues) {
            if (value.trim().length() <= 0) continue;
            keyValue.append(",'").append(SafeValueHandler.valueOf(value)).append("'");
            logger.trace("delete by id {}", (Object)value);
        }
        String keyValues = keyValue.substring(1).replace(";", "");
        String partitionKeyValue = (String)parametersMap.get("partitionKey");
        FieldColumnMapper partitionKeyColumnMapper = FieldMetadata.getPartitionKey(entityClass);
        FieldColumnMapper idFieldColumnMapper = FieldMetadata.getIdColumn(entityClass);
        SQL sql = (SQL)new SQL().DELETE_FROM(TableMetadata.getTableName(entityClass));
        if (partitionKeyColumnMapper != null && partitionKeyValue != null) {
            sql.WHERE("%s = #{%s} and %s  in ( %s )".formatted(partitionKeyColumnMapper.getColumnName(), partitionKeyValue, idFieldColumnMapper.getColumnName(), idFieldColumnMapper.getFieldName()));
        } else {
            sql.WHERE(" %s in ( %s )".formatted(idFieldColumnMapper.getColumnName(), keyValues));
        }
        String deleteSql = sql.toString();
        logger.trace("Delete SQL \n{}", (Object)deleteSql);
        return deleteSql;
    }

    public String deleteByQuery(Class<?> entityClass, Query query) {
        logger.trace("delete By Query \n{}", (Object)query);
        FieldMetadata.buildColumnMapper(entityClass);
        SQL sql = (SQL)((SQL)new SQL().DELETE_FROM(TableMetadata.getTableName(entityClass))).WHERE(QueryBuilder.build(query));
        logger.trace("delete By Query SQL \n{}", (Object)sql);
        return sql.toString();
    }

    public String deleteByLambdaQuery(Class<?> entityClass, LambdaQuery<T> lambdaQuery) {
        logger.trace("delete By LambdaQuery \n{}", lambdaQuery);
        FieldMetadata.buildColumnMapper(entityClass);
        SQL sql = (SQL)((SQL)new SQL().DELETE_FROM(TableMetadata.getTableName(entityClass))).WHERE(LambdaQueryBuilder.build(lambdaQuery));
        logger.trace("delete By LambdaQuery SQL \n{}", (Object)sql);
        return sql.toString();
    }
}

