/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.metadata;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.dromara.mybatis.jpa.crypto.EncryptFactory;
import org.dromara.mybatis.jpa.id.IdentifierGeneratorFactory;
import org.dromara.mybatis.jpa.metadata.MetadataConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapperMetadata {
    private static final Logger logger = LoggerFactory.getLogger(MapperMetadata.class);
    static ConcurrentMap<String, String> sqlsMap = new ConcurrentHashMap<String, String>();
    static IdentifierGeneratorFactory identifierGeneratorFactory = new IdentifierGeneratorFactory();
    static EncryptFactory encryptFactory;

    public static String tableOrColumnCaseConverter(String name) {
        if (MetadataConstants.TABLE_COLUMN_CASE == 1) {
            name = name.toLowerCase();
        } else if (MetadataConstants.TABLE_COLUMN_CASE == 2) {
            name = name.toUpperCase();
        }
        return name;
    }

    public static String tableOrColumnEscape(String name) {
        return MetadataConstants.TABLE_COLUMN_ESCAPE ? MetadataConstants.TABLE_COLUMN_ESCAPE_CHAR + name + MetadataConstants.TABLE_COLUMN_ESCAPE_CHAR : name;
    }

    public static ConcurrentMap<String, String> getSqlsMap() {
        return sqlsMap;
    }

    public static void setSqlsMap(ConcurrentMap<String, String> sqlsMap) {
        MapperMetadata.sqlsMap = sqlsMap;
    }

    public static IdentifierGeneratorFactory getIdentifierGeneratorFactory() {
        return identifierGeneratorFactory;
    }

    public static void setIdentifierGeneratorFactory(IdentifierGeneratorFactory identifierGeneratorFactory) {
        MapperMetadata.identifierGeneratorFactory = identifierGeneratorFactory;
        logger.debug("Identifier Generator Factory {}", (Object)identifierGeneratorFactory);
    }

    public static EncryptFactory getEncryptFactory() {
        return encryptFactory;
    }

    public static void setEncryptFactory(EncryptFactory encryptFactory) {
        MapperMetadata.encryptFactory = encryptFactory;
    }
}

