/*
 * Decompiled with CFR 0.152.
 */
package org.maxkey.authz.saml20.provider.xml;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.opensaml.Configuration;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.saml2.core.AttributeStatement;
import org.opensaml.saml2.core.AttributeValue;
import org.opensaml.saml2.core.impl.AttributeBuilder;
import org.opensaml.saml2.core.impl.AttributeStatementBuilder;
import org.opensaml.xml.XMLObjectBuilderFactory;
import org.opensaml.xml.schema.XSString;
import org.opensaml.xml.schema.impl.XSStringBuilder;
import org.springframework.security.core.GrantedAuthority;

public class AttributeStatementGenerator {
    private final XMLObjectBuilderFactory builderFactory = Configuration.getBuilderFactory();

    public AttributeStatement generateAttributeStatement(Collection<GrantedAuthority> authorities) {
        return this.generateAttributeStatement(authorities, null);
    }

    public AttributeStatement generateAttributeStatement(Collection<GrantedAuthority> authorities, HashMap<String, String> attributeMap) {
        AttributeStatementBuilder attributeStatementBuilder = (AttributeStatementBuilder)this.builderFactory.getBuilder(AttributeStatement.DEFAULT_ELEMENT_NAME);
        AttributeStatement attributeStatement = attributeStatementBuilder.buildObject();
        if (null != authorities) {
            Attribute attributeGrantedAuthority = this.builderGrantedAuthority(authorities);
            attributeStatement.getAttributes().add(attributeGrantedAuthority);
        }
        if (null != attributeMap) {
            for (Map.Entry<String, String> entry : attributeMap.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                Attribute attribute = this.builderAttribute(key, value);
                attributeStatement.getAttributes().add(attribute);
            }
        }
        return attributeStatement;
    }

    public Attribute builderAttribute(String attributeName, String value) {
        AttributeBuilder attributeBuilder = (AttributeBuilder)this.builderFactory.getBuilder(Attribute.DEFAULT_ELEMENT_NAME);
        Attribute attribute = attributeBuilder.buildObject();
        attribute.setName(attributeName);
        attribute.setNameFormat("Attribute");
        XSStringBuilder stringBuilder = (XSStringBuilder)this.builderFactory.getBuilder(XSString.TYPE_NAME);
        XSString stringValue = (XSString)stringBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME, XSString.TYPE_NAME);
        stringValue.setValue(value);
        attribute.getAttributeValues().add(stringValue);
        return attribute;
    }

    public Attribute builderGrantedAuthority(Collection<GrantedAuthority> authorities) {
        AttributeBuilder attributeBuilder = (AttributeBuilder)this.builderFactory.getBuilder(Attribute.DEFAULT_ELEMENT_NAME);
        Attribute attribute = attributeBuilder.buildObject();
        attribute.setName(GrantedAuthority.class.getName());
        attribute.setNameFormat("urn:oasis:names:tc:SAML:2.0:attrname-format:basic");
        for (GrantedAuthority grantedAuthority : authorities) {
            XSStringBuilder stringBuilder = (XSStringBuilder)Configuration.getBuilderFactory().getBuilder(XSString.TYPE_NAME);
            XSString stringValue = (XSString)stringBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME, XSString.TYPE_NAME);
            stringValue.setValue(grantedAuthority.getAuthority());
            attribute.getAttributeValues().add(stringValue);
        }
        return attribute;
    }
}

