/*
 * Decompiled with CFR 0.152.
 */
package org.maxkey.authz.saml20.provider.endpoint;

import java.security.KeyStore;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.maxkey.authz.saml.common.AuthnRequestInfo;
import org.maxkey.authz.saml20.BindingAdapter;
import org.maxkey.authz.saml20.ExtractBindingAdapter;
import org.maxkey.authz.saml20.xml.SAML2ValidatorSuite;
import org.maxkey.crypto.keystore.KeyStoreUtil;
import org.maxkey.dao.service.AppsSaml20DetailsService;
import org.maxkey.domain.apps.AppsSAML20Details;
import org.maxkey.web.WebContext;
import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.ws.message.decoder.MessageDecodingException;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.validation.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class SingleSignOnEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(SingleSignOnEndpoint.class);
    private BindingAdapter bindingAdapter;
    @Autowired
    @Qualifier(value="postSimpleSignBindingAdapter")
    private BindingAdapter postSimpleSignBindingAdapter;
    @Autowired
    @Qualifier(value="postBindingAdapter")
    private BindingAdapter postBindingAdapter;
    @Autowired
    @Qualifier(value="extractPostBindingAdapter")
    private ExtractBindingAdapter extractPostBindingAdapter;
    @Autowired
    @Qualifier(value="extractRedirectBindingAdapter")
    private ExtractBindingAdapter extractRedirectBindingAdapter;
    @Autowired
    @Qualifier(value="samlValidaotrSuite")
    private SAML2ValidatorSuite validatorSuite;
    @Autowired
    private AppsSaml20DetailsService saml20DetailsService;

    @RequestMapping(value={"/authz/saml20/{appid}"}, method={RequestMethod.POST})
    public ModelAndView authorizePost(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="appid") String appId) throws Exception {
        return this.extractSAMLRequest(this.extractPostBindingAdapter, appId, request);
    }

    @RequestMapping(value={"/authz/saml20/{appid}"}, method={RequestMethod.GET})
    public ModelAndView authorizeRedirect(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="appid") String appId) throws Exception {
        return this.extractSAMLRequest(this.extractRedirectBindingAdapter, appId, request);
    }

    public ModelAndView extractSAMLRequest(ExtractBindingAdapter extractBindingAdapter, String appId, HttpServletRequest request) throws Exception {
        logger.debug("SAML Redirect Binding , app id is " + appId);
        this.extractSaml20Detail(extractBindingAdapter, appId);
        this.extractSAMLMessage(extractBindingAdapter, request);
        request.getSession().setAttribute("samlv20Adapter", (Object)this.bindingAdapter);
        return WebContext.forward((String)"/authz/saml20/assertion");
    }

    public void extractSaml20Detail(ExtractBindingAdapter extractBindingAdapter, String samlId) throws Exception {
        AppsSAML20Details saml20Details = this.saml20DetailsService.getAppDetails(samlId);
        if (saml20Details == null) {
            logger.error("Request SAML APPID [" + samlId + "] is not exist .");
            throw new Exception();
        }
        KeyStore trustKeyStore = KeyStoreUtil.bytes2KeyStore((byte[])saml20Details.getKeyStore(), (String)extractBindingAdapter.getKeyStoreLoader().getKeyStore().getType(), (String)extractBindingAdapter.getKeyStoreLoader().getKeystorePassword());
        extractBindingAdapter.setSaml20Detail(saml20Details);
        extractBindingAdapter.buildSecurityPolicyResolver(trustKeyStore);
    }

    public void extractSAMLMessage(ExtractBindingAdapter extractBindingAdapter, HttpServletRequest request) throws Exception {
        SAMLMessageContext messageContext;
        logger.debug("extract SAML Message .");
        try {
            messageContext = extractBindingAdapter.extractSAMLMessageContext(request);
        }
        catch (MessageDecodingException e1) {
            logger.error("Exception decoding SAML MessageDecodingException", (Throwable)e1);
            throw new Exception(e1);
        }
        catch (SecurityException e1) {
            logger.error("Exception decoding SAML SecurityException", (Throwable)e1);
            throw new Exception(e1);
        }
        logger.debug("validate SAML AuthnRequest .");
        AuthnRequest authnRequest = (AuthnRequest)messageContext.getInboundSAMLMessage();
        try {
            this.validatorSuite.validate((XMLObject)authnRequest);
        }
        catch (ValidationException ve) {
            logger.warn("AuthnRequest Message failed Validation", (Throwable)ve);
            throw new Exception(ve);
        }
        logger.debug("Select Authz  Binding.");
        String binding = extractBindingAdapter.getSaml20Detail().getBinding();
        if (binding.endsWith("PostSimpleSign")) {
            this.bindingAdapter = this.postSimpleSignBindingAdapter;
            logger.debug("Authz POST Binding is  use PostSimpleSign .");
        } else {
            this.bindingAdapter = this.postBindingAdapter;
            logger.debug("Authz POST Binding is  use Post .");
        }
        AuthnRequestInfo authnRequestInfo = new AuthnRequestInfo(authnRequest.getAssertionConsumerServiceURL(), authnRequest.getID());
        logger.debug("AuthnRequest vefified.  Forwarding to AuthnResponder", (Object)authnRequestInfo);
        this.bindingAdapter.setAuthnRequestInfo(authnRequestInfo);
        this.bindingAdapter.setExtractBindingAdapter(extractBindingAdapter);
        String relayState = request.getParameter("RelayState");
        if (relayState != null) {
            this.bindingAdapter.setRelayState(relayState);
            logger.debug("RelayState : ", (Object)relayState);
        }
    }

    public void setValidatorSuite(SAML2ValidatorSuite validatorSuite) {
        this.validatorSuite = validatorSuite;
    }
}

