/*
 * Decompiled with CFR 0.152.
 */
package org.maxkey.authz.saml20.provider.binding.encoding;

import java.io.UnsupportedEncodingException;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.opensaml.Configuration;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.saml2.binding.encoding.HTTPPostEncoder;
import org.opensaml.saml2.core.RequestAbstractType;
import org.opensaml.saml2.core.StatusResponseType;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.message.encoder.MessageEncodingException;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.security.SecurityConfiguration;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.SecurityHelper;
import org.opensaml.xml.security.SigningUtil;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.keyinfo.KeyInfoGenerator;
import org.opensaml.xml.signature.KeyInfo;
import org.opensaml.xml.util.Base64;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class WebServicePostEncoder
extends HTTPPostEncoder {
    private final Logger log = LoggerFactory.getLogger(WebServicePostEncoder.class);

    public WebServicePostEncoder(VelocityEngine engine, String templateId) {
        super(engine, templateId);
    }

    public VelocityContext encodeMsgContext(MessageContext messageContext) throws MessageEncodingException {
        SAMLMessageContext samlMsgCtx = (SAMLMessageContext)messageContext;
        SAMLObject outboundMessage = samlMsgCtx.getOutboundSAMLMessage();
        if (outboundMessage == null) {
            throw new MessageEncodingException("No outbound SAML message contained in message context");
        }
        this.signMessage(samlMsgCtx);
        samlMsgCtx.setOutboundMessage((XMLObject)outboundMessage);
        return this.encodeMsgContext(samlMsgCtx);
    }

    protected VelocityContext encodeMsgContext(SAMLMessageContext messageContext) throws MessageEncodingException {
        try {
            VelocityContext context = new VelocityContext();
            this.populateVelocityContext(context, messageContext);
            return context;
        }
        catch (Exception e) {
            this.log.error("Error invoking velocity template", (Throwable)e);
            throw new MessageEncodingException("Error creating output document", e);
        }
    }

    protected void populateVelocityContext(VelocityContext velocityContext, SAMLMessageContext messageContext) throws MessageEncodingException {
        String kiBase64;
        block7: {
            this.log.debug("Marshalling and Base64 encoding SAML message");
            if (messageContext.getOutboundSAMLMessage().getDOM() == null) {
                this.marshallMessage((XMLObject)messageContext.getOutboundSAMLMessage());
            }
            try {
                String messageXML = XMLHelper.nodeToString((Node)messageContext.getOutboundSAMLMessage().getDOM());
                String encodedMessage = Base64.encodeBytes((byte[])messageXML.getBytes("UTF-8"), (int)8);
                if (messageContext.getOutboundSAMLMessage() instanceof RequestAbstractType) {
                    velocityContext.put("SAMLRequest", (Object)encodedMessage);
                    break block7;
                }
                if (messageContext.getOutboundSAMLMessage() instanceof StatusResponseType) {
                    velocityContext.put("SAMLResponse", (Object)encodedMessage);
                    break block7;
                }
                throw new MessageEncodingException("SAML message is neither a SAML RequestAbstractType or StatusResponseType");
            }
            catch (UnsupportedEncodingException e) {
                this.log.error("UTF-8 encoding is not supported, this VM is not Java compliant.");
                throw new MessageEncodingException("Unable to encode message, UTF-8 encoding is not supported");
            }
        }
        Credential signingCredential = messageContext.getOuboundSAMLMessageSigningCredential();
        if (signingCredential == null) {
            this.log.debug("No signing credential was supplied, skipping HTTP-Post simple signing");
            return;
        }
        String sigAlgURI = this.getSignatureAlgorithmURI(signingCredential, null);
        velocityContext.put("SigAlg", (Object)sigAlgURI);
        String formControlData = this.buildFormDataToSign(velocityContext, messageContext, sigAlgURI);
        velocityContext.put("Signature", (Object)this.generateSignature(signingCredential, sigAlgURI, formControlData));
        KeyInfoGenerator kiGenerator = SecurityHelper.getKeyInfoGenerator((Credential)signingCredential, null, null);
        if (kiGenerator != null && !DatatypeHelper.isEmpty((String)(kiBase64 = this.buildKeyInfo(signingCredential, kiGenerator)))) {
            velocityContext.put("KeyInfo", (Object)kiBase64);
        }
    }

    protected String buildKeyInfo(Credential signingCredential, KeyInfoGenerator kiGenerator) throws MessageEncodingException {
        try {
            KeyInfo keyInfo = kiGenerator.generate(signingCredential);
            if (keyInfo != null) {
                Marshaller marshaller = Configuration.getMarshallerFactory().getMarshaller((XMLObject)keyInfo);
                if (marshaller == null) {
                    this.log.error("No KeyInfo marshaller available from configuration");
                    throw new MessageEncodingException("No KeyInfo marshaller was configured");
                }
                String kiXML = XMLHelper.nodeToString((Node)marshaller.marshall((XMLObject)keyInfo));
                String kiBase64 = Base64.encodeBytes((byte[])kiXML.getBytes(), (int)8);
                return kiBase64;
            }
            return null;
        }
        catch (SecurityException e) {
            this.log.error("Error generating KeyInfo from signing credential", (Throwable)e);
            throw new MessageEncodingException("Error generating KeyInfo from signing credential", (Exception)((Object)e));
        }
        catch (MarshallingException e) {
            this.log.error("Error marshalling KeyInfo based on signing credential", (Throwable)e);
            throw new MessageEncodingException("Error marshalling KeyInfo based on signing credential", (Exception)((Object)e));
        }
    }

    protected String buildFormDataToSign(VelocityContext velocityContext, SAMLMessageContext messageContext, String sigAlgURI) {
        StringBuilder builder = new StringBuilder();
        boolean isRequest = false;
        if (velocityContext.get("SAMLRequest") != null) {
            isRequest = true;
        }
        String msgB64 = isRequest ? (String)velocityContext.get("SAMLRequest") : (String)velocityContext.get("SAMLResponse");
        String msg = null;
        try {
            msg = new String(Base64.decode((String)msgB64), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (isRequest) {
            builder.append("SAMLRequest=" + msg);
        } else {
            builder.append("SAMLResponse=" + msg);
        }
        if (messageContext.getRelayState() != null) {
            builder.append("&RelayState=" + messageContext.getRelayState());
        }
        builder.append("&SigAlg=" + sigAlgURI);
        return builder.toString();
    }

    protected String getSignatureAlgorithmURI(Credential credential, SecurityConfiguration config) throws MessageEncodingException {
        SecurityConfiguration secConfig = config != null ? config : Configuration.getGlobalSecurityConfiguration();
        String signAlgo = secConfig.getSignatureAlgorithmURI(credential);
        if (signAlgo == null) {
            throw new MessageEncodingException("The signing credential's algorithm URI could not be derived");
        }
        return signAlgo;
    }

    protected String generateSignature(Credential signingCredential, String algorithmURI, String formData) throws MessageEncodingException {
        this.log.debug(String.format("Generating signature with key type '%s', algorithm URI '%s' over form control string '%s'", SecurityHelper.extractSigningKey((Credential)signingCredential).getAlgorithm(), algorithmURI, formData));
        String b64Signature = null;
        try {
            byte[] rawSignature = SigningUtil.signWithURI((Credential)signingCredential, (String)algorithmURI, (byte[])formData.getBytes("UTF-8"));
            b64Signature = Base64.encodeBytes((byte[])rawSignature, (int)8);
            this.log.debug("Generated digital signature value (base64-encoded) {}", (Object)b64Signature);
        }
        catch (SecurityException e) {
            this.log.error("Error during URL signing process", (Throwable)e);
            throw new MessageEncodingException("Unable to sign form control string", (Exception)((Object)e));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return b64Signature;
    }
}

